/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;

public abstract class LookAheadResultIterator
implements PeekingResultIterator {
    private static final Tuple UNINITIALIZED = ResultTuple.EMPTY_TUPLE;
    private Tuple next = UNINITIALIZED;

    public static PeekingResultIterator wrap(final ResultIterator iterator) {
        if (iterator instanceof PeekingResultIterator) {
            return (PeekingResultIterator)iterator;
        }
        return new LookAheadResultIterator(){

            @Override
            public void explain(List<String> planSteps) {
                iterator.explain(planSteps);
            }

            @Override
            public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
                iterator.explain(planSteps, explainPlanAttributesBuilder);
            }

            @Override
            public void close() throws SQLException {
                iterator.close();
            }

            @Override
            protected Tuple advance() throws SQLException {
                return iterator.next();
            }
        };
    }

    protected abstract Tuple advance() throws SQLException;

    private void init() throws SQLException {
        if (this.next == UNINITIALIZED) {
            this.next = this.advance();
        }
    }

    @Override
    public Tuple next() throws SQLException {
        this.init();
        Tuple next = this.next;
        this.next = this.advance();
        return next;
    }

    @Override
    public Tuple peek() throws SQLException {
        this.init();
        return this.next;
    }
}

