/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.optimize;

import java.util.Objects;

public class Cost
implements Comparable<Cost> {
    public static Cost UNKNOWN = new Cost(Double.NaN, Double.NaN, Double.NaN){

        @Override
        public String toString() {
            return "{unknown}";
        }
    };
    public static Cost ZERO = new Cost(0.0, 0.0, 0.0){

        @Override
        public String toString() {
            return "{zero}";
        }
    };
    private final double cpu;
    private final double memory;
    private final double io;

    public Cost(double cpu, double memory, double io) {
        this.cpu = cpu;
        this.memory = memory;
        this.io = io;
    }

    public double getCpu() {
        return this.cpu;
    }

    public double getMemory() {
        return this.memory;
    }

    public double getIo() {
        return this.io;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public Cost plus(Cost other) {
        if (this.isUnknown() || other.isUnknown()) {
            return UNKNOWN;
        }
        return new Cost(this.cpu + other.cpu, this.memory + other.memory, this.io + other.io);
    }

    public Cost multiplyBy(double factor) {
        if (this.isUnknown()) {
            return UNKNOWN;
        }
        return new Cost(this.cpu * factor, this.memory * factor, this.io * factor);
    }

    @Override
    public int compareTo(Cost other) {
        if (this.isUnknown() && other.isUnknown()) {
            return 0;
        }
        if (this.isUnknown() && !other.isUnknown()) {
            return 1;
        }
        if (!this.isUnknown() && other.isUnknown()) {
            return -1;
        }
        double d = this.io - other.io;
        return d == 0.0 ? 0 : (d > 0.0 ? 1 : -1);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Cost && this.compareTo((Cost)obj) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.cpu, this.memory, this.io);
    }

    public String toString() {
        return "{cpu: " + this.cpu + ", memory: " + this.memory + ", io: " + this.io + "}";
    }
}

