/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.apache.phoenix.exception.PhoenixParserException;
import org.apache.phoenix.parse.BindableStatement;
import org.apache.phoenix.parse.CloseStatement;
import org.apache.phoenix.parse.DeclareCursorStatement;
import org.apache.phoenix.parse.FetchStatement;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.OpenStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.PhoenixSQLLexer;
import org.apache.phoenix.parse.PhoenixSQLParser;
import org.apache.phoenix.parse.SelectStatement;

public class SQLParser {
    private static final ParseNodeFactory DEFAULT_NODE_FACTORY = new ParseNodeFactory();
    private final PhoenixSQLParser parser;

    public static ParseNode parseCondition(String expression) throws SQLException {
        if (expression == null) {
            return null;
        }
        SQLParser parser = new SQLParser(expression);
        return parser.parseExpression();
    }

    public SQLParser(String query) {
        this(query, DEFAULT_NODE_FACTORY);
    }

    public SQLParser(String query, ParseNodeFactory factory) {
        PhoenixSQLLexer lexer;
        try {
            lexer = new PhoenixSQLLexer(new CaseInsensitiveReaderStream(new StringReader(query)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CommonTokenStream cts = new CommonTokenStream(lexer);
        this.parser = new PhoenixSQLParser(cts);
        this.parser.setParseNodeFactory(factory);
    }

    public SQLParser(Reader queryReader, ParseNodeFactory factory) throws IOException {
        PhoenixSQLLexer lexer = new PhoenixSQLLexer(new CaseInsensitiveReaderStream(queryReader));
        CommonTokenStream cts = new CommonTokenStream(lexer);
        this.parser = new PhoenixSQLParser(cts);
        this.parser.setParseNodeFactory(factory);
    }

    public SQLParser(Reader queryReader) throws IOException {
        PhoenixSQLLexer lexer = new PhoenixSQLLexer(new CaseInsensitiveReaderStream(queryReader));
        CommonTokenStream cts = new CommonTokenStream(lexer);
        this.parser = new PhoenixSQLParser(cts);
        this.parser.setParseNodeFactory(DEFAULT_NODE_FACTORY);
    }

    public BindableStatement nextStatement(ParseNodeFactory factory) throws SQLException {
        try {
            this.parser.resetBindCount();
            this.parser.setParseNodeFactory(factory);
            BindableStatement statement = this.parser.nextStatement();
            return statement;
        }
        catch (RecognitionException e) {
            throw PhoenixParserException.newException(e, this.parser.getTokenNames());
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw PhoenixParserException.newException(e, this.parser.getTokenNames());
        }
    }

    public BindableStatement parseStatement() throws SQLException {
        try {
            BindableStatement statement = this.parser.statement();
            return statement;
        }
        catch (RecognitionException e) {
            throw PhoenixParserException.newException(e, this.parser.getTokenNames());
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw PhoenixParserException.newException(e, this.parser.getTokenNames());
        }
    }

    public SelectStatement parseQuery() throws SQLException {
        try {
            SelectStatement statement = this.parser.query();
            return statement;
        }
        catch (RecognitionException e) {
            throw PhoenixParserException.newException(e, this.parser.getTokenNames());
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw PhoenixParserException.newException(e, this.parser.getTokenNames());
        }
    }

    public DeclareCursorStatement parseDeclareCursor() throws SQLException {
        try {
            DeclareCursorStatement statement = this.parser.declare_cursor_node();
            return statement;
        }
        catch (RecognitionException e) {
            throw PhoenixParserException.newException(e, this.parser.getTokenNames());
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw PhoenixParserException.newException(e, this.parser.getTokenNames());
        }
    }

    public OpenStatement parseOpen() throws SQLException {
        try {
            OpenStatement statement = this.parser.cursor_open_node();
            return statement;
        }
        catch (RecognitionException e) {
            throw PhoenixParserException.newException(e, this.parser.getTokenNames());
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw PhoenixParserException.newException(e, this.parser.getTokenNames());
        }
    }

    public CloseStatement parseClose() throws SQLException {
        try {
            CloseStatement statement = this.parser.cursor_close_node();
            return statement;
        }
        catch (RecognitionException e) {
            throw PhoenixParserException.newException(e, this.parser.getTokenNames());
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw PhoenixParserException.newException(e, this.parser.getTokenNames());
        }
    }

    public FetchStatement parseFetch() throws SQLException {
        try {
            FetchStatement statement = this.parser.cursor_fetch_node();
            return statement;
        }
        catch (RecognitionException e) {
            throw PhoenixParserException.newException(e, this.parser.getTokenNames());
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw PhoenixParserException.newException(e, this.parser.getTokenNames());
        }
    }

    public ParseNode parseExpression() throws SQLException {
        try {
            ParseNode node = this.parser.expression();
            return node;
        }
        catch (RecognitionException e) {
            throw PhoenixParserException.newException(e, this.parser.getTokenNames());
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw PhoenixParserException.newException(e, this.parser.getTokenNames());
        }
    }

    public LiteralParseNode parseLiteral() throws SQLException {
        try {
            LiteralParseNode literalNode = this.parser.literal();
            return literalNode;
        }
        catch (RecognitionException e) {
            throw PhoenixParserException.newException(e, this.parser.getTokenNames());
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw PhoenixParserException.newException(e, this.parser.getTokenNames());
        }
    }

    private static class CaseInsensitiveReaderStream
    extends ANTLRReaderStream {
        CaseInsensitiveReaderStream(Reader script) throws IOException {
            super(script);
        }

        @Override
        public int LA(int i) {
            if (i == 0) {
                return 0;
            }
            if (i < 0) {
                ++i;
            }
            if (this.p + i - 1 >= this.n) {
                return -1;
            }
            return Character.toLowerCase(this.data[this.p + i - 1]);
        }
    }
}

