/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.IteratorUtils;

public class InstanceResolver {
    private static final ConcurrentHashMap<Class, Object> RESOLVED_SINGLETONS = new ConcurrentHashMap();

    private InstanceResolver() {
    }

    public static <T> T getSingleton(Class<T> clazz, T defaultInstance) {
        Object obj = RESOLVED_SINGLETONS.get(clazz);
        if (obj != null) {
            return (T)obj;
        }
        if (defaultInstance != null && !clazz.isInstance(defaultInstance)) {
            throw new IllegalArgumentException("defaultInstance is not of type " + clazz.getName());
        }
        T o = InstanceResolver.resolveSingleton(clazz, defaultInstance);
        obj = RESOLVED_SINGLETONS.putIfAbsent(clazz, o);
        if (obj == null) {
            obj = o;
        }
        return (T)obj;
    }

    public static <T> List get(Class<T> clazz, List<T> defaultInstances) {
        Iterator<T> iterator = ServiceLoader.load(clazz).iterator();
        if (defaultInstances != null) {
            defaultInstances.addAll(IteratorUtils.toList(iterator));
        } else {
            defaultInstances = IteratorUtils.toList(iterator);
        }
        return defaultInstances;
    }

    private static synchronized <T> T resolveSingleton(Class<T> clazz, T defaultInstance) {
        ServiceLoader<T> loader = ServiceLoader.load(clazz);
        Iterator<T> iterator = loader.iterator();
        if (iterator.hasNext()) {
            T singleton = iterator.next();
            return singleton;
        }
        return defaultInstance;
    }

    @VisibleForTesting
    public static void clearSingletons() {
        RESOLVED_SINGLETONS.clear();
    }
}

