/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.NavigableSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.ReversedStoreScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreScanner;

public class ScanInfoUtil {
    public static final String PHOENIX_MAX_LOOKBACK_AGE_CONF_KEY = "phoenix.max.lookback.age.seconds";
    public static final int DEFAULT_PHOENIX_MAX_LOOKBACK_AGE = 0;

    private ScanInfoUtil() {
    }

    public static boolean isKeepDeletedCells(ScanInfo scanInfo) {
        return scanInfo.getKeepDeletedCells() != KeepDeletedCells.FALSE;
    }

    public static ScanInfo cloneScanInfoWithKeepDeletedCells(ScanInfo scanInfo) {
        return new ScanInfo(scanInfo.getConfiguration(), scanInfo.getFamily(), scanInfo.getMinVersions(), scanInfo.getMaxVersions(), scanInfo.getTtl(), KeepDeletedCells.TRUE, scanInfo.getTimeToPurgeDeletes(), scanInfo.getComparator());
    }

    public static StoreScanner createStoreScanner(Store store, ScanInfo scanInfo, Scan scan, NavigableSet<byte[]> columns, long readPt) throws IOException {
        if (!scan.isReversed()) {
            return new StoreScanner(store, scanInfo, scan, columns, readPt);
        }
        return new ReversedStoreScanner(store, scanInfo, scan, columns, readPt);
    }

    public static long getTimeToLiveForCompactions(HColumnDescriptor columnDescriptor, ScanInfo scanInfo) {
        long ttl = scanInfo.getTtl();
        long maxLookbackTtl = ScanInfoUtil.getMaxLookbackInMillis(scanInfo.getConfiguration());
        if (ScanInfoUtil.isMaxLookbackTimeEnabled(maxLookbackTtl)) {
            ttl = ttl == Long.MAX_VALUE && columnDescriptor.getKeepDeletedCells() != KeepDeletedCells.TRUE ? maxLookbackTtl : Math.max(ttl, maxLookbackTtl);
        }
        return ttl;
    }

    private static KeepDeletedCells getKeepDeletedCells(Store store, ScanType scanType) {
        return store.getFamily().getKeepDeletedCells() == KeepDeletedCells.TRUE || scanType.equals((Object)ScanType.COMPACT_RETAIN_DELETES) ? KeepDeletedCells.TRUE : KeepDeletedCells.TTL;
    }

    private static int getMinVersions(ScanInfo oldScanInfo, Store store) {
        return oldScanInfo.getTtl() != Long.MAX_VALUE ? store.getFamily().getMinVersions() : Math.max(Math.max(store.getFamily().getMinVersions(), store.getFamily().getMaxVersions()), 1);
    }

    public static ScanInfo getScanInfoForFlushesAndCompactions(Configuration conf, ScanInfo oldScanInfo, Store store, ScanType type) {
        long ttl = ScanInfoUtil.getTimeToLiveForCompactions(store.getFamily(), oldScanInfo);
        KeepDeletedCells keepDeletedCells = ScanInfoUtil.getKeepDeletedCells(store, type);
        int minVersions = ScanInfoUtil.getMinVersions(oldScanInfo, store);
        return new ScanInfo(conf, store.getFamily().getName(), minVersions, Integer.MAX_VALUE, ttl, keepDeletedCells, oldScanInfo.getTimeToPurgeDeletes(), oldScanInfo.getComparator());
    }

    public static long getMaxLookbackInMillis(Configuration conf) {
        return conf.getLong(PHOENIX_MAX_LOOKBACK_AGE_CONF_KEY, 0L) * 1000L;
    }

    public static boolean isMaxLookbackTimeEnabled(Configuration conf) {
        return ScanInfoUtil.isMaxLookbackTimeEnabled(conf.getLong(PHOENIX_MAX_LOOKBACK_AGE_CONF_KEY, 0L));
    }

    public static boolean isMaxLookbackTimeEnabled(long maxLookbackTime) {
        return maxLookbackTime > 0L;
    }
}

