/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.transaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.metrics.MetricsUtils;
import org.apache.omid.metrics.Timer;
import org.apache.omid.transaction.AbstractTransaction;
import org.apache.omid.transaction.CellUtils;
import org.apache.omid.transaction.HBaseCellId;
import org.apache.omid.transaction.HBaseTransaction;
import org.apache.omid.transaction.HBaseTransactionManager;
import org.apache.omid.transaction.PostCommitActions;
import org.apache.omid.transaction.TransactionManagerException;
import org.apache.omid.tso.client.CellId;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ListenableFuture;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.SettableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseSyncPostCommitter
implements PostCommitActions {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseSyncPostCommitter.class);
    private final MetricsRegistry metrics;
    private final CommitTable.Client commitTableClient;
    private final Timer commitTableUpdateTimer;
    private final Timer shadowCellsUpdateTimer;
    static final int MAX_BATCH_SIZE = 1000;
    private final Connection connection;

    public HBaseSyncPostCommitter(MetricsRegistry metrics, CommitTable.Client commitTableClient, Connection connection) {
        this.metrics = metrics;
        this.commitTableClient = commitTableClient;
        this.commitTableUpdateTimer = metrics.timer(MetricsUtils.name("omid", "tm", "hbase", "commitTableUpdate", "latency"));
        this.shadowCellsUpdateTimer = metrics.timer(MetricsUtils.name("omid", "tm", "hbase", "shadowCellsUpdate", "latency"));
        this.connection = connection;
    }

    private void flushMutations(TableName tableName, List<Mutation> mutations) throws IOException, InterruptedException {
        try (Table table = this.connection.getTable(tableName);){
            table.batch(mutations, new Object[mutations.size()]);
        }
    }

    private void addShadowCell(HBaseCellId cell, HBaseTransaction tx, SettableFuture<Void> updateSCFuture, Map<TableName, List<Mutation>> mutations) throws IOException, InterruptedException {
        Put put = new Put(cell.getRow());
        put.addColumn(cell.getFamily(), CellUtils.addShadowCellSuffixPrefix(cell.getQualifier(), 0, cell.getQualifier().length), cell.getTimestamp(), Bytes.toBytes((long)tx.getCommitTimestamp()));
        TableName table = cell.getTable().getHTable().getName();
        List<Mutation> tableMutations = mutations.get(table);
        if (tableMutations == null) {
            ArrayList<Put> newList = new ArrayList<Put>();
            newList.add(put);
            mutations.put(table, newList);
        } else {
            tableMutations.add((Mutation)put);
            if (tableMutations.size() > 1000) {
                this.flushMutations(table, tableMutations);
                mutations.remove(table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<Void> updateShadowCells(AbstractTransaction<? extends CellId> transaction) {
        SettableFuture updateSCFuture = SettableFuture.create();
        HBaseTransaction tx = HBaseTransactionManager.enforceHBaseTransactionAsParam(transaction);
        this.shadowCellsUpdateTimer.start();
        try {
            HashMap<TableName, List<Mutation>> mutations = new HashMap<TableName, List<Mutation>>();
            for (HBaseCellId hBaseCellId : tx.getWriteSet()) {
                this.addShadowCell(hBaseCellId, tx, (SettableFuture<Void>)updateSCFuture, mutations);
            }
            for (HBaseCellId hBaseCellId : tx.getConflictFreeWriteSet()) {
                this.addShadowCell(hBaseCellId, tx, (SettableFuture<Void>)updateSCFuture, mutations);
            }
            for (Map.Entry entry : mutations.entrySet()) {
                this.flushMutations((TableName)entry.getKey(), (List)entry.getValue());
            }
            updateSCFuture.set(null);
        }
        catch (IOException | InterruptedException e) {
            LOG.warn("{}: Error inserting shadow cells", (Object)tx, (Object)e);
            updateSCFuture.setException((Throwable)new TransactionManagerException(tx + ": Error inserting shadow cells ", e));
        }
        finally {
            this.shadowCellsUpdateTimer.stop();
        }
        return updateSCFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<Void> removeCommitTableEntry(AbstractTransaction<? extends CellId> transaction) {
        SettableFuture updateSCFuture = SettableFuture.create();
        HBaseTransaction tx = HBaseTransactionManager.enforceHBaseTransactionAsParam(transaction);
        this.commitTableUpdateTimer.start();
        try {
            this.commitTableClient.deleteCommitEntry(tx.getStartTimestamp()).get();
            updateSCFuture.set(null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("{}: interrupted during commit table entry delete", (Object)tx, (Object)e);
            updateSCFuture.setException((Throwable)new TransactionManagerException(tx + ": interrupted during commit table entry delete"));
        }
        catch (ExecutionException e) {
            LOG.warn("{}: can't remove commit table entry", (Object)tx, (Object)e);
            updateSCFuture.setException((Throwable)new TransactionManagerException(tx + ": can't remove commit table entry"));
        }
        finally {
            this.commitTableUpdateTimer.stop();
        }
        return updateSCFuture;
    }
}

