/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.name.Named;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.pool2.ObjectPool;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.metrics.Meter;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.tso.Batch;
import org.apache.omid.tso.FatalExceptionHandler;
import org.apache.omid.tso.MonitoringContext;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.ReplyProcessor;
import org.apache.omid.tso.RetryProcessor;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RetryProcessorImpl
implements EventHandler<RetryEvent>,
RetryProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RetryProcessor.class);
    private final ExecutorService disruptorExec;
    private final Disruptor<RetryEvent> disruptor;
    private final RingBuffer<RetryEvent> retryRing;
    final ReplyProcessor replyProc;
    final CommitTable.Client commitTableClient;
    final ObjectPool<Batch> batchPool;
    private final Meter txAlreadyCommittedMeter;
    private final Meter invalidTxMeter;
    private final Meter noCTFoundMeter;

    @Inject
    RetryProcessorImpl(@Named(value="RetryStrategy") WaitStrategy strategy, MetricsRegistry metrics, CommitTable commitTable, ReplyProcessor replyProc, Panicker panicker, ObjectPool<Batch> batchPool) throws InterruptedException, ExecutionException, IOException {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("retry-%d").build();
        this.disruptorExec = Executors.newSingleThreadExecutor(threadFactory);
        this.disruptor = new Disruptor<RetryEvent>(RetryEvent.EVENT_FACTORY, 4096, this.disruptorExec, ProducerType.SINGLE, strategy);
        this.disruptor.handleExceptionsWith(new FatalExceptionHandler(panicker));
        this.disruptor.handleEventsWith(this);
        this.retryRing = this.disruptor.start();
        this.commitTableClient = commitTable.getClient();
        this.replyProc = replyProc;
        this.batchPool = batchPool;
        this.txAlreadyCommittedMeter = metrics.meter(MetricRegistry.name("tso", "retries", "commits", "tx-already-committed"));
        this.invalidTxMeter = metrics.meter(MetricRegistry.name("tso", "retries", "aborts", "tx-invalid"));
        this.noCTFoundMeter = metrics.meter(MetricRegistry.name("tso", "retries", "aborts", "tx-without-commit-timestamp"));
        LOG.info("RetryProcessor initialized");
    }

    @Override
    public void onEvent(RetryEvent event, long sequence, boolean endOfBatch) throws Exception {
        switch (event.getType()) {
            case COMMIT: {
                this.handleCommitRetry(event);
                event.getMonCtx().timerStop("retry.processor.commit-retry.latency");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        event.getMonCtx().publish();
    }

    private void handleCommitRetry(RetryEvent event) {
        long startTimestamp = event.getStartTimestamp();
        try {
            Optional commitTimestamp = (Optional)this.commitTableClient.getCommitTimestamp(startTimestamp).get();
            if (commitTimestamp.isPresent()) {
                if (((CommitTable.CommitTimestamp)commitTimestamp.get()).isValid()) {
                    LOG.trace("Tx {}: Valid commit TS found in Commit Table. Sending Commit to client.", (Object)startTimestamp);
                    this.replyProc.sendCommitResponse(startTimestamp, ((CommitTable.CommitTimestamp)commitTimestamp.get()).getValue(), event.getChannel(), event.getMonCtx(), (Optional<Long>)Optional.absent());
                    this.txAlreadyCommittedMeter.mark();
                } else {
                    LOG.trace("Tx {}: Invalid tx marker found. Sending Abort to client.", (Object)startTimestamp);
                    this.replyProc.sendAbortResponse(startTimestamp, event.getChannel(), event.getMonCtx());
                    this.invalidTxMeter.mark();
                }
            } else {
                LOG.trace("Tx {}: No Commit TS found in Commit Table. Sending Abort to client.", (Object)startTimestamp);
                this.replyProc.sendAbortResponse(startTimestamp, event.getChannel(), event.getMonCtx());
                this.noCTFoundMeter.mark();
            }
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted reading from commit table");
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOG.error("Error reading from commit table", (Throwable)e);
        }
    }

    @Override
    public void disambiguateRetryRequestHeuristically(long startTimestamp, Channel c, MonitoringContext monCtx) {
        long seq = this.retryRing.next();
        RetryEvent e = this.retryRing.get(seq);
        monCtx.timerStart("retry.processor.commit-retry.latency");
        RetryEvent.makeCommitRetry(e, startTimestamp, c, monCtx);
        this.retryRing.publish(seq);
    }

    @Override
    public void close() throws IOException {
        LOG.info("Terminating Retry Processor...");
        this.disruptor.halt();
        this.disruptor.shutdown();
        LOG.info("\tRetry Processor Disruptor shutdown");
        this.disruptorExec.shutdownNow();
        try {
            this.disruptorExec.awaitTermination(3L, TimeUnit.SECONDS);
            LOG.info("\tRetry Processor Disruptor executor shutdown");
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted whilst finishing Retry Processor Disruptor executor");
            Thread.currentThread().interrupt();
        }
        LOG.info("Retry Processor terminated");
    }

    public static final class RetryEvent {
        private Type type = null;
        private long startTimestamp = 0L;
        private Channel channel = null;
        private MonitoringContext monCtx;
        public static final EventFactory<RetryEvent> EVENT_FACTORY = new EventFactory<RetryEvent>(){

            @Override
            public RetryEvent newInstance() {
                return new RetryEvent();
            }
        };

        static void makeCommitRetry(RetryEvent e, long startTimestamp, Channel c, MonitoringContext monCtx) {
            e.monCtx = monCtx;
            e.type = Type.COMMIT;
            e.startTimestamp = startTimestamp;
            e.channel = c;
        }

        MonitoringContext getMonCtx() {
            return this.monCtx;
        }

        Type getType() {
            return this.type;
        }

        Channel getChannel() {
            return this.channel;
        }

        long getStartTimestamp() {
            return this.startTimestamp;
        }

        static enum Type {
            COMMIT;

        }
    }
}

