/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Set;
import org.apache.omid.TestUtils;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.proto.TSOProto;
import org.apache.omid.tso.PausableTimestampOracle;
import org.apache.omid.tso.ReplyProcessor;
import org.apache.omid.tso.TSOMockModule;
import org.apache.omid.tso.TSOServer;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.omid.tso.TimestampOracle;
import org.apache.omid.tso.client.CellId;
import org.apache.omid.tso.client.OmidClientConfiguration;
import org.apache.omid.tso.client.TSOClient;
import org.apache.omid.tso.client.TSOClientOneShot;
import org.apache.omid.tso.util.DummyCellIdImpl;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.mockito.Mock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestTSOLL {
    private static final Logger LOG = LoggerFactory.getLogger(TestTSOLL.class);
    private static final String TSO_SERVER_HOST = "localhost";
    private static final int TSO_SERVER_PORT = 1234;
    private OmidClientConfiguration tsoClientConf;
    private TSOServer tsoServer;
    private PausableTimestampOracle pausableTSOracle;
    private CommitTable commitTable;
    private static final CellId c1 = new DummyCellIdImpl(3735928559L);
    private static final CellId c2 = new DummyCellIdImpl(4276996862L);
    private static final Set<CellId> testWriteSet = Sets.newHashSet((Object[])new CellId[]{c1, c2});
    @Mock
    ReplyProcessor replyProcessor;

    @BeforeMethod
    public void beforeMethod() throws Exception {
        TSOServerConfig tsoConfig = new TSOServerConfig();
        tsoConfig.setLowLatency(true);
        tsoConfig.setConflictMapSize(1000);
        tsoConfig.setPort(1234);
        tsoConfig.setTimestampType(TSOServerConfig.TIMESTAMP_TYPE.INCREMENTAL.toString());
        tsoConfig.setNumConcurrentCTWriters(2);
        TSOMockModule tsoServerMockModule = new TSOMockModule(tsoConfig);
        Injector injector = Guice.createInjector((Module[])new Module[]{tsoServerMockModule});
        LOG.info("==================================================================================================");
        LOG.info("======================================= Init TSO Server ==========================================");
        LOG.info("==================================================================================================");
        this.tsoServer = (TSOServer)((Object)injector.getInstance(TSOServer.class));
        this.tsoServer.startAsync();
        this.tsoServer.awaitRunning();
        TestUtils.waitForSocketListening(TSO_SERVER_HOST, 1234, 100);
        LOG.info("==================================================================================================");
        LOG.info("===================================== TSO Server Initialized =====================================");
        LOG.info("==================================================================================================");
        this.pausableTSOracle = (PausableTimestampOracle)injector.getInstance(TimestampOracle.class);
        this.commitTable = (CommitTable)injector.getInstance(CommitTable.class);
        OmidClientConfiguration tsoClientConf = new OmidClientConfiguration();
        tsoClientConf.setConnectionString("localhost:1234");
        this.tsoClientConf = tsoClientConf;
        this.commitTable = (CommitTable)injector.getInstance(CommitTable.class);
        this.replyProcessor = (ReplyProcessor)injector.getInstance(ReplyProcessor.class);
    }

    @AfterMethod
    public void afterMethod() throws Exception {
        this.tsoServer.stopAsync();
        this.tsoServer.awaitTerminated();
        this.tsoServer = null;
        TestUtils.waitForSocketNotListening(TSO_SERVER_HOST, 1234, 1000);
        this.pausableTSOracle.resume();
    }

    @Test(timeOut=30000L)
    public void testNoWriteToCommitTable() throws Exception {
        TSOClient client = TSOClient.newInstance(this.tsoClientConf);
        TSOClientOneShot clientOneShot = new TSOClientOneShot(TSO_SERVER_HOST, 1234);
        long ts1 = (Long)client.getNewStartTimestamp().get();
        TSOProto.Response response1 = clientOneShot.makeRequest(this.createCommitRequest(ts1, false, testWriteSet));
        Assert.assertTrue((boolean)response1.getCommitResponse().hasCommitTimestamp());
        Optional cts = (Optional)this.commitTable.getClient().getCommitTimestamp(ts1).get();
        Assert.assertTrue((!cts.isPresent() ? 1 : 0) != 0);
    }

    private TSOProto.Request createCommitRequest(long ts, boolean retry, Set<CellId> writeSet) {
        TSOProto.Request.Builder builder = TSOProto.Request.newBuilder();
        TSOProto.CommitRequest.Builder commitBuilder = TSOProto.CommitRequest.newBuilder();
        commitBuilder.setStartTimestamp(ts);
        commitBuilder.setIsRetry(retry);
        for (CellId cell : writeSet) {
            commitBuilder.addCellId(cell.getCellId());
        }
        return builder.setCommitRequest(commitBuilder.build()).build();
    }
}

