/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.ColumnExpression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.SchemaUtil;

public class KeyValueColumnExpression
extends ColumnExpression {
    private byte[] cf;
    private byte[] cq;
    private String displayName;

    public KeyValueColumnExpression() {
    }

    public KeyValueColumnExpression(PColumn column) {
        super(column);
        this.cf = column.getFamilyName().getBytes();
        this.cq = column.getColumnQualifierBytes() != null ? column.getColumnQualifierBytes() : column.getName().getBytes();
        this.displayName = column.getName().getString();
    }

    public KeyValueColumnExpression(PColumn column, String displayName) {
        super(column);
        this.cf = column.getFamilyName().getBytes();
        this.cq = column.getColumnQualifierBytes() != null ? column.getColumnQualifierBytes() : column.getName().getBytes();
        this.displayName = displayName;
    }

    public KeyValueColumnExpression(PDatum column, byte[] cf, byte[] cq) {
        super(column);
        this.cf = cf;
        this.cq = cq;
    }

    public byte[] getColumnFamily() {
        return this.cf;
    }

    public byte[] getColumnQualifier() {
        return this.cq;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.cf);
        result = 31 * result + Arrays.hashCode(this.cq);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyValueColumnExpression other = (KeyValueColumnExpression)obj;
        if (!Arrays.equals(this.cf, other.cf)) {
            return false;
        }
        return Arrays.equals(this.cq, other.cq);
    }

    public String toString() {
        if (this.displayName == null) {
            this.displayName = SchemaUtil.getColumnDisplayName(this.cf, this.cq);
        }
        return this.displayName;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        return tuple.getValue(this.cf, this.cq, ptr);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.cf = Bytes.readByteArray((DataInput)input);
        this.cq = Bytes.readByteArray((DataInput)input);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        Bytes.writeByteArray((DataOutput)output, (byte[])this.cf);
        Bytes.writeByteArray((DataOutput)output, (byte[])this.cq);
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

