/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import com.force.db.i18n.LinguisticSort;
import com.force.i18n.LocaleUtils;
import java.io.DataInput;
import java.io.IOException;
import java.sql.SQLException;
import java.text.Collator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.BooleanUtils;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.VarBinaryFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionParseNode.BuiltInFunction(name="COLLATION_KEY", args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class}, isConstant=true), @FunctionParseNode.Argument(allowedTypes={PBoolean.class}, defaultValue="false", isConstant=true), @FunctionParseNode.Argument(allowedTypes={PInteger.class}, defaultValue="null", isConstant=true), @FunctionParseNode.Argument(allowedTypes={PInteger.class}, defaultValue="null", isConstant=true)})
public class CollationKeyFunction
extends ScalarFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollationKeyFunction.class);
    public static final String NAME = "COLLATION_KEY";
    private Collator collator;

    public CollationKeyFunction() {
    }

    public CollationKeyFunction(List<Expression> children) throws SQLException {
        super(children);
        this.initialize();
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.initialize();
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression expression = this.getChildren().get(0);
        if (!expression.evaluate(tuple, ptr)) {
            return false;
        }
        String inputString = (String)PVarchar.INSTANCE.toObject(ptr, expression.getSortOrder());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("CollationKey inputString: " + inputString);
        }
        if (inputString == null) {
            return true;
        }
        byte[] collationKeyByteArray = this.collator.getCollationKey(inputString).toByteArray();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("CollationKey bytes: " + VarBinaryFormatter.INSTANCE.format(collationKeyByteArray));
        }
        ptr.set(collationKeyByteArray);
        return true;
    }

    private void initialize() {
        String localeISOCode = this.getLiteralValue(1, String.class);
        Boolean useSpecialUpperCaseCollator = this.getLiteralValue(2, Boolean.class);
        Integer collatorStrength = this.getLiteralValue(3, Integer.class);
        Integer collatorDecomposition = this.getLiteralValue(4, Integer.class);
        if (LOGGER.isTraceEnabled()) {
            StringBuilder logInputsMessage = new StringBuilder();
            logInputsMessage.append("Input (literal) arguments:").append("localeISOCode: " + localeISOCode).append(", useSpecialUpperCaseCollator: " + useSpecialUpperCaseCollator).append(", collatorStrength: " + collatorStrength).append(", collatorDecomposition: " + collatorDecomposition);
            LOGGER.trace(logInputsMessage.toString());
        }
        Locale locale = LocaleUtils.get().getLocaleByIsoCode(localeISOCode);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Locale: " + locale.toLanguageTag(), new Object[0]));
        }
        LinguisticSort linguisticSort = LinguisticSort.get(locale);
        Collator collator = this.collator = BooleanUtils.isTrue((Boolean)useSpecialUpperCaseCollator) ? linguisticSort.getUpperCaseCollator(false) : linguisticSort.getCollator();
        if (collatorStrength != null) {
            this.collator.setStrength(collatorStrength);
        }
        if (collatorDecomposition != null) {
            this.collator.setDecomposition(collatorDecomposition);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Collator: [strength: %d, decomposition: %d], Special-Upper-Case: %s", this.collator.getStrength(), this.collator.getDecomposition(), BooleanUtils.isTrue((Boolean)useSpecialUpperCaseCollator)));
        }
    }

    @Override
    public PDataType getDataType() {
        return PVarbinary.INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public boolean isNullable() {
        return this.getChildren().get(0).isNullable();
    }
}

