/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.phoenix.util.EnvironmentEdgeManager;

public class PagedFilter
extends FilterBase
implements Writable {
    State state;
    private long pageSizeMs;
    private long startTime;
    private byte[] rowKeyAtStop;
    private Filter delegate = null;

    public PagedFilter() {
        this.init();
    }

    public PagedFilter(Filter delegate, long pageSizeMs) {
        this.init();
        this.delegate = delegate;
        this.pageSizeMs = pageSizeMs;
    }

    public Filter getDelegateFilter() {
        return this.delegate;
    }

    public void setDelegateFilter(Filter delegate) {
        this.delegate = delegate;
    }

    public byte[] getRowKeyAtStop() {
        if (this.rowKeyAtStop != null) {
            return Arrays.copyOf(this.rowKeyAtStop, this.rowKeyAtStop.length);
        }
        return null;
    }

    public boolean isStopped() {
        return this.state == State.STOPPED;
    }

    public void init() {
        this.state = State.INITIAL;
        this.rowKeyAtStop = null;
    }

    public void resetStartTime() {
        if (this.state == State.STARTED) {
            this.init();
        }
    }

    public void reset() throws IOException {
        if (this.state == State.INITIAL) {
            this.startTime = EnvironmentEdgeManager.currentTimeMillis();
            this.state = State.STARTED;
        } else if (this.state == State.STARTED && EnvironmentEdgeManager.currentTimeMillis() - this.startTime >= this.pageSizeMs) {
            this.state = State.TIME_TO_STOP;
        }
        if (this.delegate != null) {
            this.delegate.reset();
            return;
        }
        super.reset();
    }

    public Cell getNextCellHint(Cell currentKV) throws IOException {
        if (this.delegate != null) {
            return this.delegate.getNextCellHint(currentKV);
        }
        return super.getNextCellHint(currentKV);
    }

    public boolean filterRowKey(byte[] buffer, int offset, int length) throws IOException {
        if (this.state == State.TIME_TO_STOP) {
            if (this.rowKeyAtStop == null) {
                this.rowKeyAtStop = new byte[length];
                Bytes.putBytes((byte[])this.rowKeyAtStop, (int)0, (byte[])buffer, (int)offset, (int)length);
            }
            return true;
        }
        if (this.delegate != null) {
            return this.delegate.filterRowKey(buffer, offset, length);
        }
        return super.filterRowKey(buffer, offset, length);
    }

    public boolean filterAllRemaining() throws IOException {
        if (this.state == State.TIME_TO_STOP && this.rowKeyAtStop != null) {
            this.state = State.STOPPED;
            return true;
        }
        if (this.delegate != null) {
            return this.delegate.filterAllRemaining();
        }
        return super.filterAllRemaining();
    }

    public boolean hasFilterRow() {
        return true;
    }

    public boolean filterRow() throws IOException {
        if (this.state == State.TIME_TO_STOP) {
            return true;
        }
        if (this.delegate != null) {
            return this.delegate.filterRow();
        }
        return super.filterRow();
    }

    public Cell transformCell(Cell v) throws IOException {
        if (this.delegate != null) {
            return this.delegate.transformCell(v);
        }
        return super.transformCell(v);
    }

    public void filterRowCells(List<Cell> kvs) throws IOException {
        if (this.delegate != null) {
            this.delegate.filterRowCells(kvs);
            return;
        }
        super.filterRowCells(kvs);
    }

    public void setReversed(boolean reversed) {
        if (this.delegate != null) {
            this.delegate.setReversed(reversed);
        }
        super.setReversed(reversed);
    }

    public boolean isReversed() {
        if (this.delegate != null) {
            return this.delegate.isReversed();
        }
        return super.isReversed();
    }

    public boolean isFamilyEssential(byte[] name) throws IOException {
        if (this.delegate != null) {
            return this.delegate.isFamilyEssential(name);
        }
        return super.isFamilyEssential(name);
    }

    public Filter.ReturnCode filterKeyValue(Cell v) throws IOException {
        if (this.delegate != null) {
            return this.delegate.filterKeyValue(v);
        }
        return Filter.ReturnCode.INCLUDE;
    }

    public static PagedFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        try {
            return (PagedFilter)Writables.getWritable((byte[])pbBytes, (Writable)new PagedFilter());
        }
        catch (IOException e) {
            throw new DeserializationException((Throwable)e);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.pageSizeMs);
        if (this.delegate != null) {
            out.writeUTF(this.delegate.getClass().getName());
            byte[] b = this.delegate.toByteArray();
            out.writeInt(b.length);
            out.write(b);
        } else {
            out.writeUTF("");
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.pageSizeMs = in.readLong();
        String className = in.readUTF();
        if (className.length() == 0) {
            return;
        }
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new DoNotRetryIOException((Throwable)e);
        }
        Method m = null;
        try {
            m = cls.getDeclaredMethod("parseFrom", byte[].class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new DoNotRetryIOException((Throwable)e);
        }
        int length = in.readInt();
        byte[] b = new byte[length];
        in.readFully(b);
        try {
            this.delegate = (Filter)m.invoke(null, new Object[]{b});
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new DoNotRetryIOException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new DoNotRetryIOException((Throwable)e);
        }
    }

    public byte[] toByteArray() throws IOException {
        return Writables.getBytes((Writable)this);
    }

    private static enum State {
        INITIAL,
        STARTED,
        TIME_TO_STOP,
        STOPPED;

    }
}

