/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.NamedParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;
import org.apache.phoenix.parse.TableName;

public class TableWildcardParseNode
extends NamedParseNode {
    private final TableName tableName;
    private final boolean isRewrite;

    public static TableWildcardParseNode create(TableName tableName, boolean isRewrite) {
        return new TableWildcardParseNode(tableName, isRewrite);
    }

    TableWildcardParseNode(TableName tableName, boolean isRewrite) {
        super(tableName.toString());
        this.tableName = tableName;
        this.isRewrite = isRewrite;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public boolean isRewrite() {
        return this.isRewrite;
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        return visitor.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isRewrite ? 1231 : 1237);
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableWildcardParseNode other = (TableWildcardParseNode)obj;
        if (this.isRewrite != other.isRewrite) {
            return false;
        }
        return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        this.toSQL(buf);
        buf.append(".*");
    }
}

