/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameImpl;
import org.apache.phoenix.util.SchemaUtil;

public class PNameFactory {
    public static int getEstimatedSize(PName name) {
        return name == null ? 0 : name.getEstimatedSize();
    }

    private PNameFactory() {
    }

    public static PName newNormalizedName(String name) {
        return PNameFactory.newName(SchemaUtil.normalizeIdentifier(name));
    }

    public static PName newName(String name) {
        return name == null || name.isEmpty() ? PName.EMPTY_NAME : (name.equals("_0") ? PName.EMPTY_COLUMN_NAME : new PNameImpl(name));
    }

    public static PName newName(byte[] bytes) {
        return bytes == null || bytes.length == 0 ? PName.EMPTY_NAME : (Bytes.compareTo((byte[])bytes, (byte[])QueryConstants.EMPTY_COLUMN_BYTES) == 0 ? PName.EMPTY_COLUMN_NAME : new PNameImpl(bytes));
    }

    public static PName newName(byte[] bytes, int offset, int length) {
        if (bytes == null || length == 0) {
            return PName.EMPTY_NAME;
        }
        byte[] buf = new byte[length];
        System.arraycopy(bytes, offset, buf, 0, length);
        return new PNameImpl(buf);
    }
}

