/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PUnsignedSmallint;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.schema.types.PWholeNumber;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PTinyint
extends PWholeNumber<Byte> {
    public static final PTinyint INSTANCE = new PTinyint();

    private PTinyint() {
        super("TINYINT", -6, Byte.class, new ByteCodec(), 5);
    }

    @Override
    public Integer getScale(Object o) {
        return ZERO;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return PLong.INSTANCE.compareTo(lhs, rhs, rhsType);
    }

    @Override
    public boolean isComparableTo(PDataType targetType) {
        return PDecimal.INSTANCE.isComparableTo(targetType);
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return 1;
    }

    @Override
    public Integer getMaxLength(Object o) {
        return BYTE_PRECISION;
    }

    @Override
    public byte[] toBytes(Object object) {
        byte[] b = new byte[1];
        this.toBytes(object, b, 0);
        return b;
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            throw PTinyint.newIllegalDataException(this + " may not be null");
        }
        return this.getCodec().encodeByte(((Number)object).byteValue(), bytes, offset);
    }

    @Override
    public Object toObject(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            Byte b = Byte.parseByte(value);
            return b;
        }
        catch (NumberFormatException e) {
            throw PTinyint.newIllegalDataException(e);
        }
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        Object o = PLong.INSTANCE.toObject(object, actualType);
        if (!(o instanceof Long) || o == null) {
            return o;
        }
        long l = (Long)o;
        if (l < -128L || l > 127L) {
            throw PTinyint.newIllegalDataException(actualType + " value " + l + " cannot be cast to Byte without changing its value");
        }
        return (byte)l;
    }

    @Override
    public Byte toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        if (l == 0) {
            return null;
        }
        if (PTinyint.equalsAny(actualType, PDouble.INSTANCE, PUnsignedDouble.INSTANCE, PFloat.INSTANCE, PUnsignedFloat.INSTANCE, PLong.INSTANCE, PUnsignedLong.INSTANCE, PInteger.INSTANCE, PUnsignedInt.INSTANCE, PSmallint.INSTANCE, PUnsignedSmallint.INSTANCE, INSTANCE, PUnsignedTinyint.INSTANCE)) {
            return actualType.getCodec().decodeByte(b, o, sortOrder);
        }
        if (actualType == PDecimal.INSTANCE) {
            BigDecimal bd = (BigDecimal)actualType.toObject(b, o, l, actualType, sortOrder);
            return bd.byteValueExact();
        }
        PTinyint.throwConstraintViolationException(actualType, this);
        return null;
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        if (value != null && PTinyint.equalsAny(targetType, PUnsignedDouble.INSTANCE, PUnsignedFloat.INSTANCE, PUnsignedLong.INSTANCE, PUnsignedInt.INSTANCE, PUnsignedSmallint.INSTANCE, PUnsignedTinyint.INSTANCE)) {
            byte i = (Byte)value;
            return i >= 0;
        }
        return super.isCoercibleTo(targetType, value);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return this.equals(targetType) || PSmallint.INSTANCE.isCoercibleTo(targetType);
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return ((Integer)PInteger.INSTANCE.getSampleValue(maxLength, arrayLength)).byteValue();
    }

    static class ByteCodec
    extends PDataType.BaseCodec {
        ByteCodec() {
        }

        @Override
        public long decodeLong(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeByte(b, o, sortOrder);
        }

        @Override
        public int decodeInt(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeByte(b, o, sortOrder);
        }

        @Override
        public byte decodeByte(byte[] b, int o, SortOrder sortOrder) {
            Preconditions.checkNotNull((Object)((Object)sortOrder));
            PDataType.checkForSufficientLength(b, o, 1);
            int v = sortOrder == SortOrder.ASC ? b[o] ^ 0x80 : b[o] ^ 0xFF ^ 0x80;
            return (byte)v;
        }

        @Override
        public short decodeShort(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeByte(b, o, sortOrder);
        }

        @Override
        public int encodeShort(short v, byte[] b, int o) {
            PDataType.checkForSufficientLength(b, o, 1);
            if (v < -128 || v > 127) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be encoded as an Byte without changing its value");
            }
            return this.encodeByte((byte)v, b, o);
        }

        @Override
        public int encodeLong(long v, byte[] b, int o) {
            if (v < -128L || v > 127L) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be encoded as an Byte without changing its value");
            }
            return this.encodeByte((byte)v, b, o);
        }

        @Override
        public int encodeInt(int v, byte[] b, int o) {
            if (v < -128 || v > 127) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be encoded as an Byte without changing its value");
            }
            return this.encodeByte((byte)v, b, o);
        }

        @Override
        public int encodeByte(byte v, byte[] b, int o) {
            PDataType.checkForSufficientLength(b, o, 1);
            b[o] = (byte)(v ^ 0x80);
            return 1;
        }

        @Override
        public double decodeDouble(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeByte(b, o, sortOrder);
        }

        @Override
        public float decodeFloat(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeByte(b, o, sortOrder);
        }

        @Override
        public int encodeFloat(float v, byte[] b, int o) {
            if (v < -128.0f || v > 127.0f) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be encoded as an Byte without changing its value");
            }
            return this.encodeByte((byte)v, b, o);
        }

        @Override
        public int encodeDouble(double v, byte[] b, int o) {
            if (v < -128.0 || v > 127.0) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be encoded as an Byte without changing its value");
            }
            return this.encodeByte((byte)v, b, o);
        }

        @Override
        public PDataType.PhoenixArrayFactory getPhoenixArrayFactory() {
            return new PDataType.PhoenixArrayFactory(){

                @Override
                public PhoenixArray newArray(PDataType type, Object[] elements) {
                    return new PhoenixArray.PrimitiveBytePhoenixArray(type, elements);
                }
            };
        }
    }
}

