/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.twill.api.Command;
import org.apache.twill.api.ResourceReport;
import org.apache.twill.api.RunId;
import org.apache.twill.api.TwillController;
import org.apache.twill.api.TwillRunResources;
import org.apache.twill.api.logging.LogEntry;
import org.apache.twill.api.logging.LogHandler;
import org.apache.twill.api.logging.LogThrowable;
import org.apache.twill.common.Cancellable;
import org.apache.twill.discovery.ServiceDiscovered;
import org.apache.twill.discovery.ZKDiscoveryService;
import org.apache.twill.internal.AbstractZKServiceController;
import org.apache.twill.internal.json.LogEntryDecoder;
import org.apache.twill.internal.json.LogThrowableCodec;
import org.apache.twill.internal.json.StackTraceElementCodec;
import org.apache.twill.internal.kafka.client.ZKKafkaClientService;
import org.apache.twill.internal.state.Message;
import org.apache.twill.internal.state.SystemMessages;
import org.apache.twill.kafka.client.FetchedMessage;
import org.apache.twill.kafka.client.KafkaClientService;
import org.apache.twill.kafka.client.KafkaConsumer;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.twill.zookeeper.ZKClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTwillController
extends AbstractZKServiceController
implements TwillController {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTwillController.class);
    private static final Gson GSON = new Gson();
    private final Queue<LogHandler> logHandlers = new ConcurrentLinkedQueue<LogHandler>();
    private final KafkaClientService kafkaClient;
    private ZKDiscoveryService discoveryServiceClient;
    private Cancellable logCancellable;

    public AbstractTwillController(RunId runId, ZKClient zkClient, Iterable<LogHandler> logHandlers) {
        super(runId, zkClient);
        this.kafkaClient = new ZKKafkaClientService(ZKClients.namespace(zkClient, "/" + runId.getId() + "/kafka"));
        Iterables.addAll(this.logHandlers, logHandlers);
    }

    @Override
    protected synchronized void doStartUp() {
        if (!this.logHandlers.isEmpty()) {
            this.kafkaClient.startAndWait();
            this.logCancellable = this.kafkaClient.getConsumer().prepare().addFromBeginning("log", 0).consume(new LogMessageCallback(this.logHandlers));
        }
    }

    @Override
    protected synchronized void doShutDown() {
        if (this.logCancellable != null) {
            this.logCancellable.cancel();
        }
        if (this.discoveryServiceClient != null) {
            this.discoveryServiceClient.close();
        }
        this.kafkaClient.stopAndWait();
    }

    @Override
    public final synchronized void addLogHandler(LogHandler handler) {
        this.logHandlers.add(handler);
        if (this.logHandlers.size() == 1) {
            this.kafkaClient.startAndWait();
            this.logCancellable = this.kafkaClient.getConsumer().prepare().addFromBeginning("log", 0).consume(new LogMessageCallback(this.logHandlers));
        }
    }

    @Override
    public final synchronized ServiceDiscovered discoverService(String serviceName) {
        if (this.discoveryServiceClient == null) {
            this.discoveryServiceClient = new ZKDiscoveryService(this.zkClient);
        }
        return this.discoveryServiceClient.discover(serviceName);
    }

    public final ListenableFuture<Integer> changeInstances(String runnable, int newCount) {
        return this.sendMessage(SystemMessages.setInstances(runnable, newCount), newCount);
    }

    public final ListenableFuture<String> restartAllInstances(String runnableName) {
        Command updateStateCommand = Command.Builder.of("restartAllRunnableInstances").build();
        Message message = SystemMessages.updateRunnableInstances(updateStateCommand, runnableName);
        return this.sendMessage(message, updateStateCommand.getCommand());
    }

    public final ListenableFuture<Set<String>> restartInstances(Map<String, ? extends Set<Integer>> runnableToInstanceIds) {
        Map runnableToStringInstanceIds = Maps.transformEntries(runnableToInstanceIds, (Maps.EntryTransformer)new Maps.EntryTransformer<String, Set<Integer>, String>(){

            public String transformEntry(String runnableName, Set<Integer> instanceIds) {
                AbstractTwillController.this.validateInstanceIds(runnableName, instanceIds);
                return GSON.toJson(instanceIds, new TypeToken<Set<Integer>>(){}.getType());
            }
        });
        Command updateStateCommand = Command.Builder.of("restartRunnablesInstances").addOptions(runnableToStringInstanceIds).build();
        Message message = SystemMessages.updateRunnablesInstances(updateStateCommand);
        return this.sendMessage(message, runnableToInstanceIds.keySet());
    }

    public ListenableFuture<String> restartInstances(final String runnable, int instanceId, int ... moreInstanceIds) {
        LinkedHashSet instanceIds = Sets.newLinkedHashSet();
        instanceIds.add(instanceId);
        for (int id : moreInstanceIds) {
            instanceIds.add(id);
        }
        return Futures.transform(this.restartInstances((Map<String, ? extends Set<Integer>>)ImmutableMap.of((Object)runnable, (Object)instanceIds)), (Function)new Function<Set<String>, String>(){

            public String apply(Set<String> input) {
                return runnable;
            }
        });
    }

    private void validateInstanceIds(String runnable, Set<Integer> instanceIds) {
        ResourceReport resourceReport = this.getResourceReport();
        if (resourceReport == null) {
            throw new IllegalStateException("Unable to get resource report since application has not started.");
        }
        Collection<TwillRunResources> runnableResources = resourceReport.getRunnableResources(runnable);
        if (runnableResources == null) {
            throw new RuntimeException("Unable to verify run resources for runnable " + runnable);
        }
        HashSet existingInstanceIds = Sets.newHashSet();
        for (TwillRunResources twillRunResources : runnableResources) {
            existingInstanceIds.add(twillRunResources.getInstanceId());
        }
        LOG.info("Existing instance ids: {}", (Object)existingInstanceIds);
        Iterator<Object> i$ = instanceIds.iterator();
        while (i$.hasNext()) {
            int instanceId = (Integer)i$.next();
            if (existingInstanceIds.contains(instanceId)) continue;
            throw new IllegalArgumentException("Unable to find instance id " + instanceId + " for " + runnable);
        }
    }

    private static final class LogMessageCallback
    implements KafkaConsumer.MessageCallback {
        private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)LogEntry.class), new LogEntryDecoder()).registerTypeAdapter((Type)((Object)LogThrowable.class), new LogThrowableCodec()).registerTypeAdapter((Type)((Object)StackTraceElement.class), new StackTraceElementCodec()).create();
        private final Iterable<LogHandler> logHandlers;

        private LogMessageCallback(Iterable<LogHandler> logHandlers) {
            this.logHandlers = logHandlers;
        }

        @Override
        public void onReceived(Iterator<FetchedMessage> messages) {
            while (messages.hasNext()) {
                String json = Charsets.UTF_8.decode(messages.next().getPayload()).toString();
                try {
                    LogEntry entry = GSON.fromJson(json, LogEntry.class);
                    if (entry == null) continue;
                    this.invokeHandlers(entry);
                }
                catch (Exception e) {
                    LOG.error("Failed to decode log entry {}", (Object)json, (Object)e);
                }
            }
        }

        @Override
        public void finished() {
        }

        private void invokeHandlers(LogEntry entry) {
            for (LogHandler handler : this.logHandlers) {
                try {
                    handler.onLog(entry);
                }
                catch (Throwable t) {
                    LOG.warn("Exception while calling LogHandler {}", (Object)handler, (Object)t);
                }
            }
        }
    }
}

