/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Service;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.twill.api.logging.LogThrowable;
import org.apache.twill.common.Threads;
import org.apache.twill.internal.Services;
import org.apache.twill.internal.json.ILoggingEventSerializer;
import org.apache.twill.internal.json.LogThrowableCodec;
import org.apache.twill.internal.json.StackTraceElementCodec;
import org.apache.twill.internal.kafka.client.ZKKafkaClientService;
import org.apache.twill.kafka.client.Compression;
import org.apache.twill.kafka.client.KafkaClientService;
import org.apache.twill.kafka.client.KafkaPublisher;
import org.apache.twill.zookeeper.RetryStrategies;
import org.apache.twill.zookeeper.ZKClientService;
import org.apache.twill.zookeeper.ZKClientServices;
import org.apache.twill.zookeeper.ZKClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaAppender
extends AppenderBase<ILoggingEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaAppender.class);
    private final AtomicReference<KafkaPublisher.Preparer> publisher = new AtomicReference();
    private final Runnable flushTask = this.createFlushTask();
    private final AtomicInteger bufferedSize = new AtomicInteger();
    private LogEventConverter eventConverter;
    private ZKClientService zkClientService;
    private KafkaClientService kafkaClient;
    private String zkConnectStr;
    private String hostname;
    private String runnableName;
    private String topic;
    private Queue<String> buffer = new ConcurrentLinkedQueue<String>();
    private int flushLimit = 20;
    private int flushPeriod = 100;
    private ScheduledExecutorService scheduler;

    public void setZookeeper(String zkConnectStr) {
        this.zkConnectStr = zkConnectStr;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setRunnableName(String runnableName) {
        this.runnableName = runnableName;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setFlushLimit(int flushLimit) {
        this.flushLimit = flushLimit;
    }

    public void setFlushPeriod(int flushPeriod) {
        this.flushPeriod = flushPeriod;
    }

    public void start() {
        Preconditions.checkNotNull((Object)this.zkConnectStr);
        this.eventConverter = new LogEventConverter(this.hostname, this.runnableName);
        this.scheduler = Executors.newSingleThreadScheduledExecutor(Threads.createDaemonThreadFactory("kafka-logger"));
        this.zkClientService = ZKClientServices.delegate(ZKClients.reWatchOnExpire(ZKClients.retryOnFailure(ZKClientService.Builder.of(this.zkConnectStr).build(), RetryStrategies.fixDelay(1L, TimeUnit.SECONDS))));
        this.kafkaClient = new ZKKafkaClientService(this.zkClientService);
        Futures.addCallback(Services.chainStart(this.zkClientService, this.kafkaClient), (FutureCallback)new FutureCallback<List<ListenableFuture<Service.State>>>(){

            public void onSuccess(List<ListenableFuture<Service.State>> result) {
                for (ListenableFuture<Service.State> future : result) {
                    Preconditions.checkState((Futures.getUnchecked(future) == Service.State.RUNNING ? 1 : 0) != 0, (Object)"Service is not running.");
                }
                LOG.info("Kafka client started: " + KafkaAppender.this.zkConnectStr);
                KafkaAppender.this.scheduler.scheduleWithFixedDelay(KafkaAppender.this.flushTask, 0L, KafkaAppender.this.flushPeriod, TimeUnit.MILLISECONDS);
            }

            public void onFailure(Throwable t) {
                LOG.error("Failed to start kafka appender.", t);
            }
        }, (Executor)Threads.SAME_THREAD_EXECUTOR);
        super.start();
    }

    public void stop() {
        super.stop();
        this.scheduler.shutdownNow();
        Futures.getUnchecked(Services.chainStop(this.kafkaClient, this.zkClientService));
    }

    public void forceFlush() {
        try {
            this.scheduler.submit(this.flushTask).get(2L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.error("Failed to force log flush in 2 seconds.", (Throwable)e);
        }
    }

    protected void append(ILoggingEvent eventObject) {
        this.buffer.offer(this.eventConverter.convert(eventObject));
        if (this.bufferedSize.incrementAndGet() >= this.flushLimit && this.publisher.get() != null) {
            this.scheduler.submit(this.flushTask);
        }
    }

    private int publishLogs(long timeout, TimeUnit timeoutUnit) throws TimeoutException {
        ArrayList logs = Lists.newArrayListWithExpectedSize((int)this.bufferedSize.get());
        for (String json : Iterables.consumingIterable(this.buffer)) {
            logs.add(Charsets.UTF_8.encode(json));
        }
        long backOffTime = timeoutUnit.toNanos(timeout) / 10L;
        if (backOffTime <= 0L) {
            backOffTime = 1L;
        }
        try {
            Stopwatch stopwatch = new Stopwatch();
            stopwatch.start();
            long publishTimeout = timeout;
            while (true) {
                try {
                    int published = (Integer)this.doPublishLogs(logs).get(publishTimeout, timeoutUnit);
                    this.bufferedSize.addAndGet(-published);
                    return published;
                }
                catch (ExecutionException e) {
                    LOG.error("Failed to publish logs to Kafka.", (Throwable)e);
                    TimeUnit.NANOSECONDS.sleep(backOffTime);
                    stopwatch.reset();
                    stopwatch.start();
                    if ((publishTimeout -= stopwatch.elapsedTime(timeoutUnit)) > 0L) continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Logs publish to Kafka interrupted.", (Throwable)e);
        }
        return 0;
    }

    private ListenableFuture<Integer> doPublishLogs(Collection<ByteBuffer> logs) {
        if (logs.isEmpty()) {
            return Futures.immediateFuture((Object)0);
        }
        KafkaPublisher.Preparer publisher = this.publisher.get();
        if (publisher == null) {
            try {
                KafkaPublisher.Preparer preparer = this.kafkaClient.getPublisher(KafkaPublisher.Ack.LEADER_RECEIVED, Compression.SNAPPY).prepare(this.topic);
                this.publisher.compareAndSet(null, preparer);
                publisher = this.publisher.get();
            }
            catch (Exception e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        }
        for (ByteBuffer buffer : logs) {
            publisher.add(buffer, 0);
        }
        return publisher.send();
    }

    private Runnable createFlushTask() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    int published = KafkaAppender.this.publishLogs(2L, TimeUnit.SECONDS);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Published {} log messages to Kafka.", (Object)published);
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to push logs to Kafka. Log entries dropped.", (Throwable)e);
                }
            }
        };
    }

    private static final class LogEventConverter {
        private final Gson gson;

        private LogEventConverter(String hostname, String runnableName) {
            this.gson = new GsonBuilder().registerTypeAdapter((Type)((Object)StackTraceElement.class), new StackTraceElementCodec()).registerTypeAdapter((Type)((Object)LogThrowable.class), new LogThrowableCodec()).registerTypeAdapter((Type)((Object)ILoggingEvent.class), new ILoggingEventSerializer(hostname, runnableName)).create();
        }

        private String convert(ILoggingEvent event) {
            return this.gson.toJson((Object)event, (Type)((Object)ILoggingEvent.class));
        }
    }
}

