/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.rules;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataSequence;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.rules.DataValue;
import org.apache.phoenix.pherf.rules.RuleBasedDataGenerator;

public class SequentialIntegerDataGenerator
implements RuleBasedDataGenerator {
    private final Column columnRule;
    private final AtomicLong counter;
    private final long minValue;
    private final long maxValue;

    public SequentialIntegerDataGenerator(Column columnRule) {
        Preconditions.checkArgument(columnRule.getDataSequence() == DataSequence.SEQUENTIAL);
        Preconditions.checkArgument(this.isIntegerType(columnRule.getType()));
        this.columnRule = columnRule;
        this.minValue = columnRule.getMinValue();
        this.maxValue = columnRule.getMaxValue();
        this.counter = new AtomicLong(0L);
    }

    @Override
    public DataValue getDataValue() {
        return new DataValue(this.columnRule.getType(), String.valueOf(this.counter.getAndIncrement() % (this.maxValue - this.minValue + 1L) + this.minValue));
    }

    boolean isIntegerType(DataTypeMapping mapping) {
        switch (mapping) {
            case BIGINT: 
            case INTEGER: 
            case TINYINT: 
            case UNSIGNED_LONG: {
                return true;
            }
        }
        return false;
    }
}

