/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.TimeoutBlockingWaitStrategy;
import com.lmax.disruptor.TimeoutHandler;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.tso.CommitHashMap;
import org.apache.omid.tso.FatalExceptionHandler;
import org.apache.omid.tso.LowWatermarkWriter;
import org.apache.omid.tso.MonitoringContext;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.ReplyProcessor;
import org.apache.omid.tso.RequestProcessor;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.omid.tso.TSOStateManager;
import org.apache.omid.tso.TimestampOracle;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractRequestProcessor
implements EventHandler<RequestEvent>,
RequestProcessor,
TimeoutHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRequestProcessor.class);
    private final ExecutorService disruptorExec;
    protected final Disruptor<RequestEvent> disruptor;
    protected RingBuffer<RequestEvent> requestRing;
    private final TimestampOracle timestampOracle;
    private final CommitHashMap hashmap;
    private final Map<Long, Long> tableFences;
    private final MetricsRegistry metrics;
    private final LowWatermarkWriter lowWatermarkWriter;
    private long lowWatermark = -1L;
    private final ReplyProcessor replyProcessor;

    AbstractRequestProcessor(MetricsRegistry metrics, TimestampOracle timestampOracle, Panicker panicker, TSOServerConfig config, LowWatermarkWriter lowWatermarkWriter, ReplyProcessor replyProcessor) throws IOException {
        TimeoutBlockingWaitStrategy timeoutStrategy = new TimeoutBlockingWaitStrategy(config.getBatchPersistTimeoutInMs(), TimeUnit.MILLISECONDS);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("request-%d").build();
        this.disruptorExec = Executors.newSingleThreadExecutor(threadFactory);
        this.disruptor = new Disruptor<RequestEvent>(RequestEvent.EVENT_FACTORY, 4096, this.disruptorExec, ProducerType.MULTI, (WaitStrategy)timeoutStrategy);
        this.disruptor.handleExceptionsWith(new FatalExceptionHandler(panicker));
        this.disruptor.handleEventsWith(this);
        this.metrics = metrics;
        this.timestampOracle = timestampOracle;
        this.hashmap = new CommitHashMap(config.getConflictMapSize());
        this.tableFences = new HashMap<Long, Long>();
        this.lowWatermarkWriter = lowWatermarkWriter;
        this.replyProcessor = replyProcessor;
        LOG.info("RequestProcessor initialized");
    }

    @Override
    public void update(TSOStateManager.TSOState state2) throws Exception {
        LOG.info("Initializing RequestProcessor state...");
        this.lowWatermark = state2.getLowWatermark();
        this.lowWatermarkWriter.persistLowWatermark(this.lowWatermark).get();
        LOG.info("RequestProcessor state initialized with LWMs {} and Epoch {}", (Object)this.lowWatermark, (Object)state2.getEpoch());
    }

    @Override
    public void onEvent(RequestEvent event, long sequence, boolean endOfBatch) throws Exception {
        switch (event.getType()) {
            case TIMESTAMP: {
                this.handleTimestamp(event);
                break;
            }
            case COMMIT: {
                this.handleCommit(event);
                break;
            }
            case FENCE: {
                this.handleFence(event);
                break;
            }
            default: {
                throw new IllegalStateException("Event not allowed in Request Processor: " + event);
            }
        }
    }

    @Override
    public void onTimeout(long sequence) throws Exception {
        this.onTimeout();
    }

    @Override
    public void timestampRequest(Channel c, MonitoringContext monCtx) {
        monCtx.timerStart("request.processor.timestamp.latency");
        long seq = this.requestRing.next();
        RequestEvent e = this.requestRing.get(seq);
        RequestEvent.makeTimestampRequest(e, c, monCtx);
        this.requestRing.publish(seq);
    }

    @Override
    public void commitRequest(long startTimestamp, Collection<Long> writeSet, Collection<Long> tableIdSet, boolean isRetry, Channel c, MonitoringContext monCtx) {
        monCtx.timerStart("request.processor.commit.latency");
        long seq = this.requestRing.next();
        RequestEvent e = this.requestRing.get(seq);
        RequestEvent.makeCommitRequest(e, startTimestamp, monCtx, writeSet, tableIdSet, isRetry, c);
        this.requestRing.publish(seq);
    }

    @Override
    public void fenceRequest(long tableID, Channel c, MonitoringContext monCtx) {
        monCtx.timerStart("request.processor.fence.latency");
        long seq = this.requestRing.next();
        RequestEvent e = this.requestRing.get(seq);
        RequestEvent.makeFenceRequest(e, tableID, c, monCtx);
        this.requestRing.publish(seq);
    }

    private void handleTimestamp(RequestEvent requestEvent) throws Exception {
        long timestamp = this.timestampOracle.next();
        requestEvent.getMonCtx().timerStop("request.processor.timestamp.latency");
        this.forwardTimestamp(timestamp, requestEvent.getChannel(), requestEvent.getMonCtx());
    }

    private boolean hasConflictsWithFences(long startTimestamp, Collection<Long> tableIdSet) {
        if (!this.tableFences.isEmpty()) {
            for (long tableId : tableIdSet) {
                Long fence = this.tableFences.get(tableId);
                if (fence != null && fence > startTimestamp) {
                    return true;
                }
                if (fence == null || fence >= this.lowWatermark) continue;
                this.tableFences.remove(tableId);
            }
        }
        return false;
    }

    private boolean hasConflictsWithCommittedTransactions(long startTimestamp, Iterable<Long> writeSet) {
        for (long cellId : writeSet) {
            long value = this.hashmap.getLatestWriteForCell(cellId);
            if (value == 0L || value < startTimestamp) continue;
            return true;
        }
        return false;
    }

    private void handleCommit(RequestEvent event) throws Exception {
        long startTimestamp = event.getStartTimestamp();
        Iterable<Long> writeSet = event.writeSet();
        Collection<Long> tableIdSet = event.getTableIdSet();
        boolean isCommitRetry = event.isCommitRetry();
        Channel c = event.getChannel();
        boolean nonEmptyWriteSet = writeSet.iterator().hasNext();
        if (startTimestamp > this.lowWatermark && !this.hasConflictsWithFences(startTimestamp, tableIdSet) && !this.hasConflictsWithCommittedTransactions(startTimestamp, writeSet)) {
            long commitTimestamp = this.timestampOracle.next();
            Optional forwardNewWaterMark = Optional.absent();
            if (nonEmptyWriteSet) {
                long newLowWatermark = this.lowWatermark;
                for (long r : writeSet) {
                    long removed = this.hashmap.putLatestWriteForCell(r, commitTimestamp);
                    newLowWatermark = Math.max(removed, newLowWatermark);
                }
                if (newLowWatermark != this.lowWatermark) {
                    LOG.trace("Setting new low Watermark to {}", (Object)newLowWatermark);
                    this.lowWatermark = newLowWatermark;
                    forwardNewWaterMark = Optional.of((Object)this.lowWatermark);
                }
            }
            event.getMonCtx().timerStop("request.processor.commit.latency");
            this.forwardCommit(startTimestamp, commitTimestamp, c, event.getMonCtx(), (Optional<Long>)forwardNewWaterMark);
        } else {
            event.getMonCtx().timerStop("request.processor.commit.latency");
            if (isCommitRetry) {
                this.forwardCommitRetry(startTimestamp, c, event.getMonCtx());
            } else {
                this.forwardAbort(startTimestamp, c, event.getMonCtx());
            }
        }
    }

    private void handleFence(RequestEvent event) throws Exception {
        long tableID = event.getTableId();
        Channel c = event.getChannel();
        long fenceTimestamp = this.timestampOracle.next();
        this.tableFences.put(tableID, fenceTimestamp);
        event.monCtx.timerStart("reply.processor.fence.latency");
        this.replyProcessor.sendFenceResponse(tableID, fenceTimestamp, c, event.monCtx);
    }

    @Override
    public void close() throws IOException {
        LOG.info("Terminating Request Processor...");
        this.disruptor.halt();
        this.disruptor.shutdown();
        LOG.info("\tRequest Processor Disruptor shutdown");
        this.disruptorExec.shutdownNow();
        try {
            this.disruptorExec.awaitTermination(3L, TimeUnit.SECONDS);
            LOG.info("\tRequest Processor Disruptor executor shutdown");
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted whilst finishing Request Processor Disruptor executor");
            Thread.currentThread().interrupt();
        }
        LOG.info("Request Processor terminated");
    }

    protected abstract void forwardCommit(long var1, long var3, Channel var5, MonitoringContext var6, Optional<Long> var7) throws Exception;

    protected abstract void forwardCommitRetry(long var1, Channel var3, MonitoringContext var4) throws Exception;

    protected abstract void forwardAbort(long var1, Channel var3, MonitoringContext var4) throws Exception;

    protected abstract void forwardTimestamp(long var1, Channel var3, MonitoringContext var4) throws Exception;

    protected abstract void onTimeout() throws Exception;

    static final class RequestEvent
    implements Iterable<Long> {
        private Type type = null;
        private Channel channel = null;
        private boolean isCommitRetry = false;
        private long startTimestamp = 0L;
        private MonitoringContext monCtx;
        private long numCells = 0L;
        private static final int MAX_INLINE = 40;
        private Long[] writeSet = new Long[40];
        private Collection<Long> writeSetAsCollection = null;
        private Collection<Long> tableIdSet = null;
        private long tableID = 0L;
        static final EventFactory<RequestEvent> EVENT_FACTORY = new EventFactory<RequestEvent>(){

            @Override
            public RequestEvent newInstance() {
                return new RequestEvent();
            }
        };

        RequestEvent() {
        }

        static void makeTimestampRequest(RequestEvent e, Channel c, MonitoringContext monCtx) {
            e.type = Type.TIMESTAMP;
            e.channel = c;
            e.monCtx = monCtx;
        }

        static void makeCommitRequest(RequestEvent e, long startTimestamp, MonitoringContext monCtx, Collection<Long> writeSet, Collection<Long> TableIdSet, boolean isRetry, Channel c) {
            e.monCtx = monCtx;
            e.type = Type.COMMIT;
            e.channel = c;
            e.startTimestamp = startTimestamp;
            e.isCommitRetry = isRetry;
            if (writeSet.size() > 40) {
                e.numCells = writeSet.size();
                e.writeSetAsCollection = writeSet;
            } else {
                e.writeSetAsCollection = null;
                e.numCells = writeSet.size();
                int i = 0;
                Iterator<Long> iterator = writeSet.iterator();
                while (iterator.hasNext()) {
                    Long cellId;
                    e.writeSet[i] = cellId = iterator.next();
                    ++i;
                }
            }
            e.tableIdSet = TableIdSet;
        }

        static void makeFenceRequest(RequestEvent e, long tableID, Channel c, MonitoringContext monCtx) {
            e.type = Type.FENCE;
            e.channel = c;
            e.monCtx = monCtx;
            e.tableID = tableID;
        }

        MonitoringContext getMonCtx() {
            return this.monCtx;
        }

        Type getType() {
            return this.type;
        }

        long getStartTimestamp() {
            return this.startTimestamp;
        }

        Channel getChannel() {
            return this.channel;
        }

        Collection<Long> getTableIdSet() {
            return this.tableIdSet;
        }

        long getTableId() {
            return this.tableID;
        }

        @Override
        public Iterator<Long> iterator() {
            if (this.writeSetAsCollection != null) {
                return this.writeSetAsCollection.iterator();
            }
            return new Iterator<Long>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return (long)this.i < RequestEvent.this.numCells;
                }

                @Override
                public Long next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return RequestEvent.this.writeSet[this.i++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        Iterable<Long> writeSet() {
            return this;
        }

        boolean isCommitRetry() {
            return this.isCommitRetry;
        }

        static enum Type {
            TIMESTAMP,
            COMMIT,
            FENCE;

        }
    }
}

