/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import org.apache.omid.tso.LongCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommitHashMap {
    private static final Logger LOG = LoggerFactory.getLogger(CommitHashMap.class);
    private final LongCache cellIdToCommitMap;

    public CommitHashMap() {
        this(1000);
    }

    public CommitHashMap(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Illegal size: " + size);
        }
        this.cellIdToCommitMap = new LongCache(size, 32);
        LOG.info("CellId -> CommitTS map created with [{}] buckets (32 elems/bucket)", (Object)size);
    }

    public long getLatestWriteForCell(long hash) {
        return this.cellIdToCommitMap.get(hash);
    }

    public long putLatestWriteForCell(long hash, long commitTimestamp) {
        return this.cellIdToCommitMap.set(hash, commitTimestamp);
    }
}

