/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.call;

import java.util.concurrent.Callable;
import org.apache.phoenix.call.CallWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(CallRunner.class);

    private CallRunner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V, E extends Exception, T extends CallableThrowable<V, E>> V run(T call, CallWrapper ... wrappers) throws E {
        try {
            for (CallWrapper wrap : wrappers) {
                wrap.before();
            }
            V v = call.call();
            return v;
        }
        finally {
            for (int i = wrappers.length - 1; i >= 0; --i) {
                try {
                    wrappers[i].after();
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to complete wrapper " + wrappers[i], (Throwable)e);
                }
            }
        }
    }

    public static interface CallableThrowable<V, E extends Exception>
    extends Callable<V> {
        @Override
        public V call() throws E;
    }
}

