/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.util.Bytes;

public class SuffixFilter
extends FilterBase {
    protected byte[] suffix = null;

    public SuffixFilter(byte[] suffix) {
        this.suffix = suffix;
    }

    public byte[] toByteArray() throws IOException {
        return this.suffix;
    }

    public Filter.ReturnCode filterKeyValue(Cell ignored) throws IOException {
        return Filter.ReturnCode.INCLUDE;
    }

    public boolean filterRowKey(byte[] buffer, int offset, int length) {
        if (buffer == null || this.suffix == null) {
            return true;
        }
        if (length < this.suffix.length) {
            return true;
        }
        int cmp = Bytes.compareTo((byte[])buffer, (int)(offset + (length - this.suffix.length)), (int)this.suffix.length, (byte[])this.suffix, (int)0, (int)this.suffix.length);
        return cmp != 0;
    }

    public static SuffixFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        return new SuffixFilter(pbBytes);
    }
}

