/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.expression.ColumnExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.aggregator.DistinctValueWithCountClientAggregator;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.util.BigDecimalUtil;

public abstract class BaseDecimalStddevAggregator
extends DistinctValueWithCountClientAggregator {
    private int colPrecision;
    private int colScale;

    public BaseDecimalStddevAggregator(List<Expression> exps, SortOrder sortOrder) {
        super(sortOrder);
        ColumnExpression stdDevColExp = (ColumnExpression)exps.get(0);
        this.colPrecision = stdDevColExp.getMaxLength();
        this.colScale = stdDevColExp.getScale();
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (this.cachedResult == null) {
            BigDecimal ssd = this.sumSquaredDeviation();
            ssd = ssd.divide(new BigDecimal(this.getDataPointsCount()), PDataType.DEFAULT_MATH_CONTEXT);
            int resultPrecision = this.colPrecision;
            int i = 1;
            while ((long)i < this.totalCount && resultPrecision < 38) {
                Pair<Integer, Integer> precisionScale = BigDecimalUtil.getResultPrecisionScale(this.colPrecision, this.colScale, this.colPrecision, this.colScale, BigDecimalUtil.Operation.OTHERS);
                resultPrecision = (Integer)precisionScale.getFirst();
                ++i;
            }
            BigDecimal result = new BigDecimal(Math.sqrt(ssd.doubleValue()), new MathContext(resultPrecision, RoundingMode.HALF_UP));
            result.setScale(this.colScale, RoundingMode.HALF_UP);
            this.cachedResult = result;
        }
        if (this.buffer == null) {
            this.initBuffer();
        }
        this.buffer = PDecimal.INSTANCE.toBytes(this.cachedResult);
        ptr.set(this.buffer);
        return true;
    }

    protected abstract long getDataPointsCount();

    private BigDecimal sumSquaredDeviation() {
        BigDecimal m = this.mean();
        BigDecimal result = BigDecimal.ZERO;
        for (Map.Entry entry : this.valueVsCount.entrySet()) {
            BigDecimal colValue = (BigDecimal)PDecimal.INSTANCE.toObject((ImmutableBytesWritable)entry.getKey());
            BigDecimal delta = colValue.subtract(m);
            result = result.add(delta.multiply(delta).multiply(new BigDecimal((Integer)entry.getValue())));
        }
        return result;
    }

    private BigDecimal mean() {
        BigDecimal sum = BigDecimal.ZERO;
        for (Map.Entry entry : this.valueVsCount.entrySet()) {
            BigDecimal colValue = (BigDecimal)PDecimal.INSTANCE.toObject((ImmutableBytesWritable)entry.getKey());
            sum = sum.add(colValue.multiply(new BigDecimal((Integer)entry.getValue())));
        }
        return sum.divide(new BigDecimal(this.totalCount), PDataType.DEFAULT_MATH_CONTEXT);
    }

    @Override
    protected PDataType getResultDataType() {
        return PDecimal.INSTANCE;
    }
}

