/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import java.util.List;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.Aggregators;
import org.apache.phoenix.expression.function.SingleAggregateFunction;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.TupleUtil;

public class ClientAggregators
extends Aggregators {
    private final ValueBitSet tempValueSet;

    private static Aggregator[] getAggregators(List<SingleAggregateFunction> aggFuncs) {
        Aggregator[] aggregators = new Aggregator[aggFuncs.size()];
        for (int i = 0; i < aggregators.length; ++i) {
            aggregators[i] = aggFuncs.get(i).getAggregator();
        }
        return aggregators;
    }

    public ClientAggregators(List<SingleAggregateFunction> functions, int minNullableIndex) {
        super(functions.toArray(new SingleAggregateFunction[functions.size()]), ClientAggregators.getAggregators(functions), minNullableIndex);
        this.tempValueSet = ValueBitSet.newInstance(this.schema);
    }

    @Override
    public void aggregate(Aggregator[] aggregators, Tuple result) {
        Boolean hasValue;
        TupleUtil.getAggregateValue(result, this.ptr);
        this.tempValueSet.clear();
        this.tempValueSet.or(this.ptr);
        int i = 0;
        int maxOffset = this.ptr.getOffset() + this.ptr.getLength();
        this.schema.iterator(this.ptr);
        while ((hasValue = this.schema.next(this.ptr, i, maxOffset, this.tempValueSet)) != null) {
            if (hasValue.booleanValue()) {
                aggregators[i].aggregate(result, this.ptr);
            }
            ++i;
        }
    }

    @Override
    public Aggregator[] newAggregators() {
        Aggregator[] aggregators = new Aggregator[this.functions.length];
        for (int i = 0; i < this.functions.length; ++i) {
            aggregators[i] = this.functions[i].newClientAggregator();
        }
        return aggregators;
    }
}

