/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.Date;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.PhoenixRowTimestampParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;

@FunctionParseNode.BuiltInFunction(name="PHOENIX_ROW_TIMESTAMP", nodeClass=PhoenixRowTimestampParseNode.class, args={})
public class PhoenixRowTimestampFunction
extends ScalarFunction {
    public static final String NAME = "PHOENIX_ROW_TIMESTAMP";

    public PhoenixRowTimestampFunction() {
    }

    public PhoenixRowTimestampFunction(List<Expression> children) {
        super(children);
        if (children.size() != 1 || !children.get(0).getClass().isAssignableFrom(KeyValueColumnExpression.class)) {
            throw new IllegalArgumentException("PhoenixRowTimestampFunction should only have an EMPTY_COLUMN key value expression.");
        }
        if (!children.get(0).getDataType().equals(PDate.INSTANCE)) {
            throw new IllegalArgumentException("PhoenixRowTimestampFunction should have an EMPTY_COLUMN key value expression of type PDate");
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        byte[] emptyCQ;
        if (tuple == null || tuple.size() == 0) {
            return false;
        }
        byte[] emptyCF = ((KeyValueColumnExpression)this.children.get(0)).getColumnFamily();
        Cell emptyColumnKV = tuple.getValue(emptyCF, emptyCQ = ((KeyValueColumnExpression)this.children.get(0)).getColumnQualifier());
        long ts = emptyColumnKV != null && CellUtil.matchingColumn((Cell)emptyColumnKV, (byte[])emptyCF, (byte[])emptyCQ) ? emptyColumnKV.getTimestamp() : tuple.getValue(0).getTimestamp();
        Date rowTimestamp = new Date(ts);
        ptr.set(PDate.INSTANCE.toBytes(rowTimestamp));
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PDate.INSTANCE;
    }

    @Override
    public boolean isStateless() {
        return false;
    }

    @Override
    public Determinism getDeterminism() {
        return Determinism.PER_ROW;
    }
}

