/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.util.regex;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.util.regex.AbstractBasePattern;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;

public class JavaPattern
extends AbstractBasePattern {
    private final Pattern pattern;

    public JavaPattern(String patternString) {
        this(patternString, 0);
    }

    public JavaPattern(String patternString, int flags) {
        this.pattern = patternString != null ? Pattern.compile(patternString, flags) : null;
    }

    @Override
    public void matches(ImmutableBytesWritable srcPtr) {
        boolean ret;
        Preconditions.checkNotNull((Object)srcPtr);
        String matcherSourceStr = (String)PVarchar.INSTANCE.toObject(srcPtr);
        if (srcPtr.getLength() == 0 && matcherSourceStr == null) {
            matcherSourceStr = "";
        }
        srcPtr.set((ret = this.pattern.matcher(matcherSourceStr).matches()) ? PDataType.TRUE_BYTES : PDataType.FALSE_BYTES);
    }

    @Override
    public String pattern() {
        return this.pattern.pattern();
    }

    @Override
    public void replaceAll(ImmutableBytesWritable srcPtr, byte[] rStrBytes, int rStrOffset, int rStrLen) {
        Preconditions.checkNotNull((Object)srcPtr);
        Preconditions.checkNotNull((Object)rStrBytes);
        String sourceStr = (String)PVarchar.INSTANCE.toObject(srcPtr);
        String replaceStr = (String)PVarchar.INSTANCE.toObject(rStrBytes, rStrOffset, rStrLen);
        if (srcPtr.getLength() == 0 && sourceStr == null) {
            sourceStr = "";
        }
        if (rStrLen == 0 && replaceStr == null) {
            replaceStr = "";
        }
        String replacedStr = this.pattern.matcher(sourceStr).replaceAll(replaceStr);
        srcPtr.set(PVarchar.INSTANCE.toBytes(replacedStr));
    }

    @Override
    public void substr(ImmutableBytesWritable ptr, int offsetInStr) {
        Preconditions.checkNotNull((Object)ptr);
        String sourceStr = (String)PVarchar.INSTANCE.toObject(ptr);
        if (sourceStr == null) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
        } else {
            if (offsetInStr < 0) {
                offsetInStr += sourceStr.length();
            }
            if (offsetInStr < 0 || offsetInStr >= sourceStr.length()) {
                ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            } else {
                Matcher matcher = this.pattern.matcher(sourceStr);
                boolean ret = matcher.find(offsetInStr);
                if (ret) {
                    ptr.set(PVarchar.INSTANCE.toBytes(matcher.group()));
                } else {
                    ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
                }
            }
        }
    }
}

