/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.log;

import com.lmax.disruptor.ExceptionHandler;
import org.apache.phoenix.log.RingBufferEvent;

class QueryLoggerDefaultExceptionHandler
implements ExceptionHandler<RingBufferEvent> {
    QueryLoggerDefaultExceptionHandler() {
    }

    @Override
    public void handleEventException(Throwable ex, long sequence, RingBufferEvent event) {
        StringBuilder sb = new StringBuilder(512);
        sb.append("Query Logger error handling event seq=").append(sequence).append(", value='");
        try {
            sb.append(event);
        }
        catch (Exception ignored) {
            sb.append("[ERROR calling ").append(event.getClass()).append(".toString(): ");
            sb.append(ignored).append("]");
        }
        sb.append("':");
        System.err.println(sb);
        ex.printStackTrace();
    }

    @Override
    public void handleOnStartException(Throwable throwable) {
        System.err.println("QueryLogger error starting:");
        throwable.printStackTrace();
    }

    @Override
    public void handleOnShutdownException(Throwable throwable) {
        System.err.println("QueryLogger error shutting down:");
        throwable.printStackTrace();
    }
}

