/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.log;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.log.QueryLogDetailsEventHandler;
import org.apache.phoenix.log.QueryLoggerDefaultExceptionHandler;
import org.apache.phoenix.log.RingBufferEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryLoggerDisruptor
implements Closeable {
    private volatile Disruptor<RingBufferEvent> disruptor;
    private boolean isClosed = false;
    private static final int RING_BUFFER_SIZE = 8192;
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryLoggerDisruptor.class);
    private static final String DEFAULT_WAIT_STRATEGY = BlockingWaitStrategy.class.getName();

    public QueryLoggerDisruptor(Configuration configuration) throws SQLException {
        WaitStrategy waitStrategy;
        try {
            waitStrategy = (WaitStrategy)Class.forName(configuration.get("phoenix.log.wait.strategy", DEFAULT_WAIT_STRATEGY)).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SQLException(e);
        }
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("QueryLogger-thread-%s").setDaemon(true).setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread result = Executors.defaultThreadFactory().newThread(r);
                result.setContextClassLoader(QueryLoggerDisruptor.class.getClass().getClassLoader());
                return result;
            }
        }).build();
        this.disruptor = new Disruptor<RingBufferEvent>(RingBufferEvent.FACTORY, configuration.getInt("phoenix.log.buffer.size", 8192), threadFactory, ProducerType.MULTI, waitStrategy);
        QueryLoggerDefaultExceptionHandler errorHandler = new QueryLoggerDefaultExceptionHandler();
        this.disruptor.setDefaultExceptionHandler(errorHandler);
        QueryLogDetailsEventHandler[] handlers = new QueryLogDetailsEventHandler[]{new QueryLogDetailsEventHandler(configuration)};
        this.disruptor.handleEventsWith(handlers);
        LOGGER.info("Starting  QueryLoggerDisruptor for with ringbufferSize=" + this.disruptor.getRingBuffer().getBufferSize() + ", waitStrategy=" + waitStrategy.getClass().getSimpleName() + ", exceptionHandler=" + errorHandler + "...");
        this.disruptor.start();
    }

    public boolean tryPublish(EventTranslator<RingBufferEvent> translator) {
        if (this.isClosed()) {
            return false;
        }
        return this.disruptor.getRingBuffer().tryPublishEvent(translator);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        LOGGER.info("Shutting down QueryLoggerDisruptor..");
        try {
            this.disruptor.shutdown(2L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new IOException(e);
        }
    }
}

