/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixTextInputFormat
extends TextInputFormat {
    public static final String SKIP_HEADER_KEY = "phoenix.input.format.skip.header";

    public static void setSkipHeader(Configuration conf) {
        conf.setBoolean(SKIP_HEADER_KEY, true);
    }

    public RecordReader<LongWritable, Text> createRecordReader(InputSplit split, TaskAttemptContext context) {
        RecordReader rr = super.createRecordReader(split, context);
        return new PhoenixLineRecordReader((LineRecordReader)rr);
    }

    public static class PhoenixLineRecordReader
    extends RecordReader<LongWritable, Text> {
        private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixLineRecordReader.class);
        private final LineRecordReader rr;

        private PhoenixLineRecordReader(LineRecordReader rr) {
            this.rr = rr;
        }

        public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            this.rr.initialize(genericSplit, context);
            Configuration conf = context.getConfiguration();
            FileSplit split = (FileSplit)genericSplit;
            if (conf.getBoolean(PhoenixTextInputFormat.SKIP_HEADER_KEY, false) && split.getStart() == 0L) {
                LOGGER.trace("Consuming first key-value from {}", (Object)genericSplit);
                this.nextKeyValue();
            } else {
                LOGGER.trace("Not configured to skip header or not the first input split: {}", (Object)split);
            }
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this.rr.nextKeyValue();
        }

        public LongWritable getCurrentKey() throws IOException {
            return this.rr.getCurrentKey();
        }

        public Text getCurrentValue() throws IOException {
            return this.rr.getCurrentValue();
        }

        public float getProgress() throws IOException {
            return this.rr.getProgress();
        }

        public void close() throws IOException {
            this.rr.close();
        }
    }
}

