/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.phoenix.mapreduce.PhoenixJobCounters;
import org.apache.phoenix.mapreduce.index.PhoenixServerBuildIndexDBWritable;

public class PhoenixServerBuildIndexMapper
extends Mapper<NullWritable, PhoenixServerBuildIndexDBWritable, ImmutableBytesWritable, IntWritable> {
    private long rebuildPageRowSize;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        String rebuildPageRowSizeConf = context.getConfiguration().get("phoenix.index.rebuild_page_size_in_rows");
        this.rebuildPageRowSize = rebuildPageRowSizeConf != null ? Long.valueOf(rebuildPageRowSizeConf) : -1L;
    }

    protected void map(NullWritable key, PhoenixServerBuildIndexDBWritable record, Mapper.Context context) throws IOException, InterruptedException {
        context.getCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).increment(record.getRowCount());
        if (this.rebuildPageRowSize != -1L && record.getRowCount() > this.rebuildPageRowSize) {
            throw new IOException("Rebuilt/Verified rows greater than page size. Rebuilt rows: " + record.getRowCount() + " Page size: " + this.rebuildPageRowSize);
        }
        context.progress();
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        context.write((Object)new ImmutableBytesWritable(UUID.randomUUID().toString().getBytes()), (Object)new IntWritable(0));
        super.cleanup(context);
    }
}

