/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import org.apache.hadoop.hbase.metrics.Gauge;
import org.apache.hadoop.hbase.metrics.MetricRegistries;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.MetricRegistryInfo;
import org.apache.phoenix.monitoring.GlobalMetricRegistriesAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompatGlobalClientMetricsRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompatGlobalClientMetricsRegistry.class);
    protected static MetricRegistry metricRegistry;

    protected static void createRegistry() {
        LOGGER.info("Creating Metric Registry for Phoenix Global Metrics");
        MetricRegistryInfo registryInfo = new MetricRegistryInfo("PHOENIX", "Phoenix Client Metrics", "phoenix", "Phoenix,sub=CLIENT", true);
        metricRegistry = MetricRegistries.global().create(registryInfo);
    }

    protected static void registerMetricToRegistry(String name, final ValueProvider valueProvider) {
        metricRegistry.register(name, (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return valueProvider.getValue();
            }
        });
    }

    protected static void registerMetricsAdapter(String metricTag) {
        GlobalMetricRegistriesAdapter.getInstance().registerMetricRegistry(metricRegistry, metricTag);
    }

    protected static interface ValueProvider {
        public Long getValue();
    }
}

