/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import org.apache.phoenix.monitoring.CompatGlobalClientMetricsRegistry;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.GlobalMetric;
import org.apache.phoenix.query.QueryServicesOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalClientMetricsRegistry
extends CompatGlobalClientMetricsRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalClientMetrics.class);

    public static void register() {
        if (GlobalClientMetrics.isMetricsEnabled()) {
            GlobalClientMetricsRegistry.createRegistry();
            GlobalClientMetricsRegistry.registerPhoenixMetricsToRegistry();
            GlobalClientMetricsRegistry.registerMetricsAdapter(QueryServicesOptions.withDefaults().getClientMetricTag());
        }
    }

    private static void registerPhoenixMetricsToRegistry() {
        for (GlobalClientMetrics globalMetric : GlobalClientMetrics.values()) {
            final GlobalMetric innerMetric = globalMetric.getMetric();
            GlobalClientMetricsRegistry.registerMetricToRegistry(globalMetric.getMetricType().columnName(), new CompatGlobalClientMetricsRegistry.ValueProvider(){

                @Override
                public Long getValue() {
                    return innerMetric.getValue();
                }
            });
        }
    }
}

