/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.BinaryParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;

public class LikeParseNode
extends BinaryParseNode {
    private final boolean negate;
    private final LikeType likeType;

    LikeParseNode(ParseNode lhs, ParseNode rhs, boolean negate, LikeType likeType) {
        super(lhs, rhs);
        this.negate = negate;
        this.likeType = likeType;
    }

    public boolean isNegate() {
        return this.negate;
    }

    public LikeType getLikeType() {
        return this.likeType;
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        List l = Collections.emptyList();
        if (visitor.visitEnter(this)) {
            l = this.acceptChildren(visitor);
        }
        return visitor.visitLeave(this, l);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.likeType == null ? 0 : this.likeType.hashCode());
        result = 31 * result + (this.negate ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LikeParseNode other = (LikeParseNode)obj;
        if (this.likeType != other.likeType) {
            return false;
        }
        return this.negate == other.negate;
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        List<ParseNode> children = this.getChildren();
        children.get(0).toSQL(resolver, buf);
        if (this.negate) {
            buf.append(" NOT");
        }
        buf.append(" " + (this.likeType == LikeType.CASE_SENSITIVE ? "LIKE" : "ILIKE") + " ");
        children.get(1).toSQL(resolver, buf);
    }

    public static enum LikeType {
        CASE_SENSITIVE,
        CASE_INSENSITIVE;

    }
}

