/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PSmallintArray
extends PArrayDataType<short[]> {
    public static final PSmallintArray INSTANCE = new PSmallintArray();

    private PSmallintArray() {
        super("SMALLINT ARRAY", 3000 + PSmallint.INSTANCE.getSqlType(), PhoenixArray.class, null, 31);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return this.compareTo(lhs, rhs);
    }

    @Override
    public Integer getByteSize() {
        return null;
    }

    @Override
    public byte[] toBytes(Object object) {
        return this.toBytes(object, SortOrder.ASC);
    }

    @Override
    public byte[] toBytes(Object object, SortOrder sortOrder) {
        return this.toBytes(object, PSmallint.INSTANCE, sortOrder);
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        return this.toObject(bytes, offset, length, PSmallint.INSTANCE, sortOrder, maxLength, scale, PSmallint.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return this.isCoercibleTo(targetType, this);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        short[] shortArr;
        if (value == null) {
            return true;
        }
        PhoenixArray.PrimitiveShortPhoenixArray pArr = (PhoenixArray.PrimitiveShortPhoenixArray)value;
        for (short i : shortArr = (short[])pArr.array) {
            if (super.isCoercibleTo((PDataType)PSmallint.INSTANCE, i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return this.getSampleValue(PSmallint.INSTANCE, arrayLength, maxLength);
    }
}

