/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra;

import org.apache.tephra.RetryStrategy;
import org.apache.tephra.TransactionConflictException;
import org.apache.tephra.TransactionFailureException;

public class RetryOnConflictStrategy
implements RetryStrategy {
    private final int maxRetries;
    private final long retryDelay;

    public RetryOnConflictStrategy(int maxRetries, long retryDelay) {
        this.maxRetries = maxRetries;
        this.retryDelay = retryDelay;
    }

    @Override
    public long nextRetry(TransactionFailureException reason, int failureCount) {
        if (reason instanceof TransactionConflictException) {
            return failureCount > this.maxRetries ? -1L : this.retryDelay;
        }
        return -1L;
    }
}

