/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import org.apache.twill.api.ElectionHandler;
import org.apache.twill.common.Cancellable;
import org.apache.twill.internal.zookeeper.LeaderElection;
import org.apache.twill.zookeeper.ZKClient;

public class ElectionRegistry {
    private final ZKClient zkClient;
    private final Multimap<String, LeaderElection> registry;

    public ElectionRegistry(ZKClient zkClient) {
        this.zkClient = zkClient;
        HashMultimap multimap = HashMultimap.create();
        this.registry = Multimaps.synchronizedMultimap((Multimap)multimap);
    }

    public Cancellable register(String name, ElectionHandler handler) {
        LeaderElection election = new LeaderElection(this.zkClient, name, handler);
        election.start();
        this.registry.put((Object)name, (Object)election);
        return new CancellableElection(name, election);
    }

    public void shutdown() {
        for (LeaderElection election : this.registry.values()) {
            election.stop();
        }
    }

    private class CancellableElection
    implements Cancellable {
        private final String name;
        private final LeaderElection election;

        public CancellableElection(String name, LeaderElection election) {
            this.name = name;
            this.election = election;
        }

        @Override
        public void cancel() {
            this.election.stop();
            ElectionRegistry.this.registry.remove((Object)this.name, (Object)this.election);
        }
    }
}

