/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.apache.twill.api.logging.LogThrowable;
import org.apache.twill.internal.json.DefaultLogThrowable;

public final class LogThrowableCodec
implements JsonSerializer<LogThrowable>,
JsonDeserializer<LogThrowable> {
    @Override
    public JsonElement serialize(LogThrowable throwable, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("className", throwable.getClassName());
        json.addProperty("message", throwable.getMessage());
        json.add("stackTraces", context.serialize(throwable.getStackTraces(), (Type)((Object)StackTraceElement[].class)));
        LogThrowable cause = throwable.getCause();
        if (cause != null) {
            json.add("cause", context.serialize(cause, (Type)((Object)LogThrowable.class)));
        }
        return json;
    }

    @Override
    public LogThrowable deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return (LogThrowable)context.deserialize(json, (Type)((Object)DefaultLogThrowable.class));
    }
}

