/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.joda.time.DateTimeZone;

public class PherfConstants {
    private static PherfConstants instance = null;
    private static Properties instanceProperties = null;
    public static final int DEFAULT_THREAD_POOL_SIZE = 10;
    public static final int DEFAULT_BATCH_SIZE = 1000;
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final DateTimeZone DEFAULT_TIME_ZONE = DateTimeZone.UTC;
    public static final String RESOURCE_SCENARIO = "/scenario";
    public static final String SCENARIO_ROOT_PATTERN = ".*" + "/scenario".substring(1) + ".*" + "/scenario".substring(1) + ".*";
    public static final String SCHEMA_ROOT_PATTERN = ".*";
    public static final String TEST_SCENARIO_ROOT_PATTERN = ".*test_" + "/scenario".substring(1);
    public static final String PHERF_PROPERTIES = "pherf.properties";
    public static final String EXPORT_DIR = "CSV_EXPORT";
    public static final String RESULT_PREFIX = "RESULT_";
    public static final String PATH_SEPARATOR = "/";
    public static final String RESULT_FILE_DELIMETER = ",";
    public static final String NEW_LINE = "\n";
    public static final long DEFAULT_NUMBER_OF_EXECUTIONS = 10L;
    public static final long DEFAULT_THREAD_DURATION_IN_MS = 10000L;
    public static final String DEFAULT_CONCURRENCY = "1";
    public static final String DIFF_PASS = "VERIFIED_DIFF";
    public static final String DIFF_FAIL = "FAILED_DIFF";
    public static final String PHERF_SCHEMA_NAME = "PHERF";
    public static final String LOG_PER_NROWS_NAME = "pherf.default.log_per_nrows";
    public static final int LOG_PER_NROWS = 1000000;
    public static final String COMBINED_FILE_NAME = "COMBINED";
    public static final String EXPORT_TMP = "CSV_EXPORT_TMP";
    public static final String RESOURCE_DATAMODEL = "/datamodel";
    public static final int MONITOR_FREQUENCY = 5000;
    public static final String MONITOR_FILE_NAME = "STATS_MONITOR";

    private PherfConstants() {
    }

    public static PherfConstants create() {
        if (instance == null) {
            instance = new PherfConstants();
        }
        return instance;
    }

    public Properties getProperties(String fileName, boolean getDefault) throws Exception {
        if (instanceProperties != null) {
            return getDefault ? instanceProperties : this.loadProperties(fileName);
        }
        instanceProperties = this.loadProperties(fileName);
        return instanceProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(String fileName) throws IOException {
        Properties properties = new Properties();
        try (InputStream is = null;){
            is = this.getClass().getClassLoader().getResourceAsStream(fileName);
            if (is != null) {
                properties.load(is);
            }
        }
        return properties;
    }

    public String getProperty(String property) {
        return this.getProperty(PHERF_PROPERTIES, property);
    }

    public String getProperty(String fileName, String property) {
        String value = null;
        try {
            value = this.getProperties(fileName, false).getProperty(property);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public static enum CompareType {
        MINIMUM,
        AVERAGE;

    }

    public static enum GeneratePhoenixStats {
        YES,
        NO;

    }
}

