/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.lmax.disruptor.BlockingWaitStrategy;
import java.io.IOException;
import org.apache.commons.pool2.ObjectPool;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.timestamp.storage.TimestampStorage;
import org.apache.omid.tso.Batch;
import org.apache.omid.tso.BatchPoolModule;
import org.apache.omid.tso.LeaseManagement;
import org.apache.omid.tso.LeaseManager;
import org.apache.omid.tso.LowWatermarkWriterImpl;
import org.apache.omid.tso.MockPanicker;
import org.apache.omid.tso.MonitoringContextImpl;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.PersistenceProcessorHandler;
import org.apache.omid.tso.PersistenceProcessorImpl;
import org.apache.omid.tso.ReplyProcessor;
import org.apache.omid.tso.RequestProcessorPersistCT;
import org.apache.omid.tso.RetryProcessor;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.omid.tso.TimestampOracle;
import org.apache.omid.tso.TimestampOracleImpl;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestPanicker {
    private static final Logger LOG = LoggerFactory.getLogger(TestPanicker.class);
    @Mock
    private CommitTable.Writer mockWriter;
    @Mock
    private MetricsRegistry metrics;

    @BeforeMethod
    public void initMocksAndComponents() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @AfterMethod
    void afterMethod() {
        Mockito.reset((Object[])new CommitTable.Writer[]{this.mockWriter});
    }

    @Test(timeOut=10000L)
    public void testTimestampOraclePanic() throws Exception {
        TimestampStorage storage = (TimestampStorage)Mockito.spy((Object)new TimestampOracleImpl.InMemoryTimestampStorage());
        Panicker panicker = (Panicker)Mockito.spy((Object)new MockPanicker());
        ((TimestampStorage)Mockito.doThrow((Throwable)new RuntimeException("Out of memory")).when((Object)storage)).updateMaxTimestamp(Matchers.anyLong(), Matchers.anyLong());
        final TimestampOracleImpl tso = new TimestampOracleImpl(this.metrics, storage, panicker);
        tso.initialize();
        Thread allocThread = new Thread("AllocThread"){

            @Override
            public void run() {
                while (true) {
                    tso.next();
                }
            }
        };
        allocThread.start();
        ((Panicker)Mockito.verify((Object)panicker, (VerificationMode)Mockito.timeout((int)1000).atLeastOnce())).panic(Matchers.anyString(), (Throwable)Matchers.any(Throwable.class));
    }

    @Test(timeOut=10000L)
    public void testCommitTablePanic() throws Exception {
        Panicker panicker = (Panicker)Mockito.spy((Object)new MockPanicker());
        ((CommitTable.Writer)Mockito.doThrow((Throwable)new IOException("Unable to write@TestPanicker")).when((Object)this.mockWriter)).flush();
        final CommitTable.Client mockClient = (CommitTable.Client)Mockito.mock(CommitTable.Client.class);
        CommitTable commitTable = new CommitTable(){

            @Override
            public CommitTable.Writer getWriter() {
                return TestPanicker.this.mockWriter;
            }

            @Override
            public CommitTable.Client getClient() {
                return mockClient;
            }
        };
        LeaseManager leaseManager = (LeaseManager)Mockito.mock(LeaseManager.class);
        ((LeaseManager)Mockito.doReturn((Object)true).when((Object)leaseManager)).stillInLeasePeriod();
        TSOServerConfig config = new TSOServerConfig();
        ObjectPool<Batch> batchPool = new BatchPoolModule(config).getBatchPool();
        PersistenceProcessorHandler[] handlers = new PersistenceProcessorHandler[config.getNumConcurrentCTWriters()];
        for (int i = 0; i < config.getNumConcurrentCTWriters(); ++i) {
            handlers[i] = new PersistenceProcessorHandler(this.metrics, "localhost:1234", leaseManager, commitTable, (ReplyProcessor)Mockito.mock(ReplyProcessor.class), (RetryProcessor)Mockito.mock(RetryProcessor.class), panicker);
        }
        PersistenceProcessorImpl proc = new PersistenceProcessorImpl(config, new BlockingWaitStrategy(), commitTable, batchPool, panicker, handlers, this.metrics);
        proc.addCommitToBatch(1L, 2L, null, new MonitoringContextImpl(this.metrics), (Optional<Long>)Optional.absent());
        LowWatermarkWriterImpl lowWatermarkWriter = new LowWatermarkWriterImpl(config, commitTable, this.metrics);
        new RequestProcessorPersistCT(this.metrics, (TimestampOracle)Mockito.mock(TimestampOracle.class), proc, panicker, (TSOServerConfig)Mockito.mock(TSOServerConfig.class), lowWatermarkWriter, (ReplyProcessor)Mockito.mock(ReplyProcessor.class));
        ((Panicker)Mockito.verify((Object)panicker, (VerificationMode)Mockito.timeout((int)1000).atLeastOnce())).panic(Matchers.anyString(), (Throwable)Matchers.any(Throwable.class));
    }

    @Test(timeOut=10000L)
    public void testRuntimeExceptionTakesDownDaemon() throws Exception {
        Panicker panicker = (Panicker)Mockito.spy((Object)new MockPanicker());
        final CommitTable.Writer mockWriter = (CommitTable.Writer)Mockito.mock(CommitTable.Writer.class);
        ((CommitTable.Writer)Mockito.doThrow((Throwable)new RuntimeException("Kaboom!")).when((Object)mockWriter)).addCommittedTransaction(Matchers.anyLong(), Matchers.anyLong());
        final CommitTable.Client mockClient = (CommitTable.Client)Mockito.mock(CommitTable.Client.class);
        CommitTable commitTable = new CommitTable(){

            @Override
            public CommitTable.Writer getWriter() {
                return mockWriter;
            }

            @Override
            public CommitTable.Client getClient() {
                return mockClient;
            }
        };
        TSOServerConfig config = new TSOServerConfig();
        ObjectPool<Batch> batchPool = new BatchPoolModule(config).getBatchPool();
        PersistenceProcessorHandler[] handlers = new PersistenceProcessorHandler[config.getNumConcurrentCTWriters()];
        for (int i = 0; i < config.getNumConcurrentCTWriters(); ++i) {
            handlers[i] = new PersistenceProcessorHandler(this.metrics, "localhost:1234", (LeaseManagement)Mockito.mock(LeaseManager.class), commitTable, (ReplyProcessor)Mockito.mock(ReplyProcessor.class), (RetryProcessor)Mockito.mock(RetryProcessor.class), panicker);
        }
        PersistenceProcessorImpl proc = new PersistenceProcessorImpl(config, new BlockingWaitStrategy(), commitTable, batchPool, panicker, handlers, this.metrics);
        proc.addCommitToBatch(1L, 2L, null, new MonitoringContextImpl(this.metrics), (Optional<Long>)Optional.absent());
        LowWatermarkWriterImpl lowWatermarkWriter = new LowWatermarkWriterImpl(config, commitTable, this.metrics);
        new RequestProcessorPersistCT(this.metrics, (TimestampOracle)Mockito.mock(TimestampOracle.class), proc, panicker, (TSOServerConfig)Mockito.mock(TSOServerConfig.class), lowWatermarkWriter, (ReplyProcessor)Mockito.mock(ReplyProcessor.class));
        ((Panicker)Mockito.verify((Object)panicker, (VerificationMode)Mockito.timeout((int)1000).atLeastOnce())).panic(Matchers.anyString(), (Throwable)Matchers.any(Throwable.class));
    }
}

