/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatelessExpressionCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.PhoenixIOException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.execute.visitor.ByteCountVisitor;
import org.apache.phoenix.execute.visitor.QueryPlanVisitor;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.iterate.DefaultParallelScanGrouper;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.PhoenixQueues;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.SizeAwareQueue;
import org.apache.phoenix.jdbc.PhoenixParameterMetaData;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.optimize.Cost;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.NumberUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortMergeJoinPlan
implements QueryPlan {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortMergeJoinPlan.class);
    private static final byte[] EMPTY_PTR = new byte[0];
    private final StatementContext context;
    private final FilterableStatement statement;
    private final TableRef table;
    private final JoinTableNode.JoinType joinType;
    private final QueryPlan lhsPlan;
    private final QueryPlan rhsPlan;
    private final List<Expression> lhsKeyExpressions;
    private final List<Expression> rhsKeyExpressions;
    private final KeyValueSchema joinedSchema;
    private final KeyValueSchema lhsSchema;
    private final KeyValueSchema rhsSchema;
    private final int rhsFieldPosition;
    private final boolean isSingleValueOnly;
    private final Set<TableRef> tableRefs;
    private final long thresholdBytes;
    private final boolean spoolingEnabled;
    private Long estimatedBytes;
    private Long estimatedRows;
    private Long estimateInfoTs;
    private boolean getEstimatesCalled;
    private List<OrderByCompiler.OrderBy> actualOutputOrderBys;

    public SortMergeJoinPlan(StatementContext context, FilterableStatement statement, TableRef table, JoinTableNode.JoinType type, QueryPlan lhsPlan, QueryPlan rhsPlan, Pair<List<Expression>, List<Expression>> lhsAndRhsKeyExpressions, List<Expression> rhsKeyExpressions, PTable joinedTable, PTable lhsTable, PTable rhsTable, int rhsFieldPosition, boolean isSingleValueOnly, Pair<List<OrderByNode>, List<OrderByNode>> lhsAndRhsOrderByNodes) throws SQLException {
        if (type == JoinTableNode.JoinType.Right) {
            throw new IllegalArgumentException("JoinType should not be " + (Object)((Object)type));
        }
        this.context = context;
        this.statement = statement;
        this.table = table;
        this.joinType = type;
        this.lhsPlan = lhsPlan;
        this.rhsPlan = rhsPlan;
        this.lhsKeyExpressions = (List)lhsAndRhsKeyExpressions.getFirst();
        this.rhsKeyExpressions = (List)lhsAndRhsKeyExpressions.getSecond();
        this.joinedSchema = SortMergeJoinPlan.buildSchema(joinedTable);
        this.lhsSchema = SortMergeJoinPlan.buildSchema(lhsTable);
        this.rhsSchema = SortMergeJoinPlan.buildSchema(rhsTable);
        this.rhsFieldPosition = rhsFieldPosition;
        this.isSingleValueOnly = isSingleValueOnly;
        this.tableRefs = Sets.newHashSetWithExpectedSize((int)(lhsPlan.getSourceRefs().size() + rhsPlan.getSourceRefs().size()));
        this.tableRefs.addAll(lhsPlan.getSourceRefs());
        this.tableRefs.addAll(rhsPlan.getSourceRefs());
        this.thresholdBytes = context.getConnection().getQueryServices().getProps().getLong("phoenix.query.client.spoolThresholdBytes", 0x1400000L);
        this.spoolingEnabled = context.getConnection().getQueryServices().getProps().getBoolean("phoenix.query.client.join.spooling.enabled", true);
        this.actualOutputOrderBys = SortMergeJoinPlan.convertActualOutputOrderBy((List)lhsAndRhsOrderByNodes.getFirst(), (List)lhsAndRhsOrderByNodes.getSecond(), context);
    }

    @Override
    public PhoenixStatement.Operation getOperation() {
        return this.statement.getOperation();
    }

    private static KeyValueSchema buildSchema(PTable table) {
        KeyValueSchema.KeyValueSchemaBuilder builder = new KeyValueSchema.KeyValueSchemaBuilder(0);
        if (table != null) {
            for (PColumn column : table.getColumns()) {
                if (SchemaUtil.isPKColumn(column)) continue;
                builder.addField(column);
            }
        }
        return builder.build();
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper) throws SQLException {
        return this.iterator(scanGrouper, null);
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
        return this.joinType == JoinTableNode.JoinType.Semi || this.joinType == JoinTableNode.JoinType.Anti ? new SemiAntiJoinIterator(this.lhsPlan.iterator(scanGrouper), this.rhsPlan.iterator(scanGrouper)) : new BasicJoinIterator(this.lhsPlan.iterator(scanGrouper), this.rhsPlan.iterator(scanGrouper));
    }

    @Override
    public ResultIterator iterator() throws SQLException {
        return this.iterator(DefaultParallelScanGrouper.getInstance());
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        ArrayList steps = Lists.newArrayList();
        steps.add("SORT-MERGE-JOIN (" + this.joinType.toString().toUpperCase() + ") TABLES");
        ExplainPlan lhsExplainPlan = this.lhsPlan.getExplainPlan();
        List<String> lhsPlanSteps = lhsExplainPlan.getPlanSteps();
        ExplainPlanAttributes lhsPlanAttributes = lhsExplainPlan.getPlanStepsAsAttributes();
        ExplainPlanAttributes.ExplainPlanAttributesBuilder lhsPlanBuilder = new ExplainPlanAttributes.ExplainPlanAttributesBuilder(lhsPlanAttributes);
        lhsPlanBuilder.setAbstractExplainPlan("SORT-MERGE-JOIN (" + this.joinType.toString().toUpperCase() + ")");
        for (String step : lhsPlanSteps) {
            steps.add("    " + step);
        }
        steps.add("AND" + (this.rhsSchema.getFieldCount() == 0 ? " (SKIP MERGE)" : ""));
        ExplainPlan rhsExplainPlan = this.rhsPlan.getExplainPlan();
        List<String> rhsPlanSteps = rhsExplainPlan.getPlanSteps();
        ExplainPlanAttributes rhsPlanAttributes = rhsExplainPlan.getPlanStepsAsAttributes();
        ExplainPlanAttributes.ExplainPlanAttributesBuilder rhsPlanBuilder = new ExplainPlanAttributes.ExplainPlanAttributesBuilder(rhsPlanAttributes);
        lhsPlanBuilder.setRhsJoinQueryExplainPlan(rhsPlanBuilder.build());
        for (String step : rhsPlanSteps) {
            steps.add("    " + step);
        }
        return new ExplainPlan(steps, lhsPlanBuilder.build());
    }

    @Override
    public Cost getCost() {
        Double byteCount = this.accept(new ByteCountVisitor());
        if (byteCount == null) {
            return Cost.UNKNOWN;
        }
        Cost cost = new Cost(0.0, 0.0, byteCount);
        return cost.plus(this.lhsPlan.getCost()).plus(this.rhsPlan.getCost());
    }

    @Override
    public StatementContext getContext() {
        return this.context;
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
    }

    @Override
    public long getEstimatedSize() {
        return this.lhsPlan.getEstimatedSize() + this.rhsPlan.getEstimatedSize();
    }

    @Override
    public TableRef getTableRef() {
        return this.table;
    }

    @Override
    public RowProjector getProjector() {
        return null;
    }

    @Override
    public Integer getLimit() {
        return null;
    }

    @Override
    public Integer getOffset() {
        return null;
    }

    @Override
    public OrderByCompiler.OrderBy getOrderBy() {
        return null;
    }

    @Override
    public GroupByCompiler.GroupBy getGroupBy() {
        return null;
    }

    @Override
    public List<KeyRange> getSplits() {
        return Collections.emptyList();
    }

    @Override
    public List<List<Scan>> getScans() {
        return Collections.emptyList();
    }

    @Override
    public FilterableStatement getStatement() {
        return this.statement;
    }

    @Override
    public boolean isDegenerate() {
        return false;
    }

    @Override
    public boolean isRowKeyOrdered() {
        return false;
    }

    public JoinTableNode.JoinType getJoinType() {
        return this.joinType;
    }

    private static SQLException closeIterators(ResultIterator lhsIterator, ResultIterator rhsIterator) {
        SQLException e = null;
        try {
            lhsIterator.close();
        }
        catch (Throwable e1) {
            e = e1 instanceof SQLException ? (SQLException)e1 : new SQLException(e1);
        }
        try {
            rhsIterator.close();
        }
        catch (Throwable e2) {
            SQLException e22;
            SQLException sQLException = e22 = e2 instanceof SQLException ? (SQLException)e2 : new SQLException(e2);
            if (e != null) {
                e.setNextException(e22);
            }
            e = e22;
        }
        return e;
    }

    private static void clearThreadPoolExecutor(ExecutorService threadPoolExecutor, List<Future<Boolean>> futures) {
        for (Future<Boolean> future : futures) {
            try {
                future.cancel(true);
            }
            catch (Throwable ignore) {
                LOGGER.error("cancel future error", ignore);
            }
        }
        try {
            threadPoolExecutor.shutdownNow();
        }
        catch (Throwable ignore) {
            LOGGER.error("shutdownNow threadPoolExecutor error", ignore);
        }
    }

    @Override
    public boolean useRoundRobinIterator() {
        return false;
    }

    @Override
    public <T> T accept(QueryPlanVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Set<TableRef> getSourceRefs() {
        return this.tableRefs;
    }

    public QueryPlan getLhsPlan() {
        return this.lhsPlan;
    }

    public QueryPlan getRhsPlan() {
        return this.rhsPlan;
    }

    @Override
    public Long getEstimatedRowsToScan() throws SQLException {
        if (!this.getEstimatesCalled) {
            this.getEstimates();
        }
        return this.estimatedRows;
    }

    @Override
    public Long getEstimatedBytesToScan() throws SQLException {
        if (!this.getEstimatesCalled) {
            this.getEstimates();
        }
        return this.estimatedBytes;
    }

    @Override
    public Long getEstimateInfoTimestamp() throws SQLException {
        if (!this.getEstimatesCalled) {
            this.getEstimates();
        }
        return this.estimateInfoTs;
    }

    private void getEstimates() throws SQLException {
        this.getEstimatesCalled = true;
        if (this.lhsPlan.getEstimatedBytesToScan() == null || this.rhsPlan.getEstimatedBytesToScan() == null || this.lhsPlan.getEstimatedRowsToScan() == null || this.rhsPlan.getEstimatedRowsToScan() == null || this.lhsPlan.getEstimateInfoTimestamp() == null || this.rhsPlan.getEstimateInfoTimestamp() == null) {
            this.estimatedBytes = null;
            this.estimatedRows = null;
            this.estimateInfoTs = null;
        } else {
            this.estimatedBytes = NumberUtil.add(NumberUtil.add(this.estimatedBytes, this.lhsPlan.getEstimatedBytesToScan()), this.rhsPlan.getEstimatedBytesToScan());
            this.estimatedRows = NumberUtil.add(NumberUtil.add(this.estimatedRows, this.lhsPlan.getEstimatedRowsToScan()), this.rhsPlan.getEstimatedRowsToScan());
            this.estimateInfoTs = NumberUtil.getMin(this.lhsPlan.getEstimateInfoTimestamp(), this.rhsPlan.getEstimateInfoTimestamp());
        }
    }

    private static List<OrderByCompiler.OrderBy> convertActualOutputOrderBy(List<OrderByNode> lhsOrderByNodes, List<OrderByNode> rhsOrderByNodes, StatementContext statementContext) throws SQLException {
        List<OrderByExpression> rhsOrderByExpressions;
        ArrayList<OrderByCompiler.OrderBy> orderBys = new ArrayList<OrderByCompiler.OrderBy>(2);
        List<OrderByExpression> lhsOrderByExpressions = SortMergeJoinPlan.compileOrderByNodes(lhsOrderByNodes, statementContext);
        if (!lhsOrderByExpressions.isEmpty()) {
            orderBys.add(new OrderByCompiler.OrderBy(lhsOrderByExpressions));
        }
        if (!(rhsOrderByExpressions = SortMergeJoinPlan.compileOrderByNodes(rhsOrderByNodes, statementContext)).isEmpty()) {
            orderBys.add(new OrderByCompiler.OrderBy(rhsOrderByExpressions));
        }
        if (orderBys.isEmpty()) {
            return Collections.emptyList();
        }
        return orderBys;
    }

    private static List<OrderByExpression> compileOrderByNodes(List<OrderByNode> orderByNodes, StatementContext statementContext) throws SQLException {
        StatelessExpressionCompiler expressionCompiler = new StatelessExpressionCompiler(statementContext);
        ArrayList<OrderByExpression> orderByExpressions = new ArrayList<OrderByExpression>(orderByNodes.size());
        for (OrderByNode orderByNode : orderByNodes) {
            expressionCompiler.reset();
            Expression expression = null;
            try {
                expression = orderByNode.getNode().accept(expressionCompiler);
            }
            catch (TableNotFoundException exception) {
                return orderByExpressions;
            }
            catch (ColumnNotFoundException exception) {
                return orderByExpressions;
            }
            catch (ColumnFamilyNotFoundException exception) {
                return orderByExpressions;
            }
            assert (expression != null);
            orderByExpressions.add(OrderByExpression.createByCheckIfOrderByReverse(expression, orderByNode.isNullsLast(), orderByNode.isAscending(), false));
        }
        return orderByExpressions;
    }

    @Override
    public List<OrderByCompiler.OrderBy> getOutputOrderBys() {
        return this.actualOutputOrderBys;
    }

    @Override
    public boolean isApplicable() {
        return true;
    }

    private static class JoinKey
    implements Comparable<JoinKey> {
        private final List<Expression> expressions;
        private final List<ImmutableBytesWritable> keys;

        public JoinKey(List<Expression> expressions) {
            this.expressions = expressions;
            this.keys = Lists.newArrayListWithExpectedSize((int)expressions.size());
            for (int i = 0; i < expressions.size(); ++i) {
                this.keys.add(new ImmutableBytesWritable(EMPTY_PTR));
            }
        }

        public void evaluate(Tuple tuple) {
            for (int i = 0; i < this.keys.size(); ++i) {
                if (this.expressions.get(i).evaluate(tuple, this.keys.get(i))) continue;
                this.keys.get(i).set(EMPTY_PTR);
            }
        }

        public void set(JoinKey other) {
            for (int i = 0; i < this.keys.size(); ++i) {
                ImmutableBytesWritable key = other.keys.get(i);
                this.keys.get(i).set(key.get(), key.getOffset(), key.getLength());
            }
        }

        public void clear() {
            for (int i = 0; i < this.keys.size(); ++i) {
                this.keys.get(i).set(EMPTY_PTR);
            }
        }

        public boolean equals(Object other) {
            if (!(other instanceof JoinKey)) {
                return false;
            }
            return this.compareTo((JoinKey)other) == 0;
        }

        @Override
        public int compareTo(JoinKey other) {
            for (int i = 0; i < this.keys.size(); ++i) {
                int comp = this.keys.get(i).compareTo(other.keys.get(i));
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        }
    }

    @VisibleForTesting
    public class SemiAntiJoinIterator
    implements ResultIterator {
        private final ResultIterator lhsIterator;
        private final ResultIterator rhsIterator;
        private final boolean isSemi;
        private boolean initialized;
        private Tuple lhsTuple;
        private Tuple rhsTuple;
        private JoinKey lhsKey;
        private JoinKey rhsKey;
        private boolean joinResultNullBecauseOneSideNull = false;

        public SemiAntiJoinIterator(ResultIterator lhsIterator, ResultIterator rhsIterator) {
            if (SortMergeJoinPlan.this.joinType != JoinTableNode.JoinType.Semi && SortMergeJoinPlan.this.joinType != JoinTableNode.JoinType.Anti) {
                throw new IllegalArgumentException("Type " + (Object)((Object)SortMergeJoinPlan.this.joinType) + " is not allowed by " + SemiAntiJoinIterator.class.getName());
            }
            this.lhsIterator = lhsIterator;
            this.rhsIterator = rhsIterator;
            this.isSemi = SortMergeJoinPlan.this.joinType == JoinTableNode.JoinType.Semi;
            this.initialized = false;
            this.lhsTuple = null;
            this.rhsTuple = null;
            this.lhsKey = new JoinKey(SortMergeJoinPlan.this.lhsKeyExpressions);
            this.rhsKey = new JoinKey(SortMergeJoinPlan.this.rhsKeyExpressions);
        }

        public boolean isJoinResultNullBecauseOneSideNull() {
            return this.joinResultNullBecauseOneSideNull;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        @Override
        public void close() throws SQLException {
            SQLException sqlException = SortMergeJoinPlan.closeIterators(this.lhsIterator, this.rhsIterator);
            if (sqlException != null) {
                LOGGER.error("SemiAntiJoinIterator close error!", (Throwable)sqlException);
            }
        }

        private void init() throws SQLException {
            ExecutorService threadPoolExecutor = Executors.newFixedThreadPool(2);
            ExecutorCompletionService<Boolean> executorCompletionService = new ExecutorCompletionService<Boolean>(threadPoolExecutor);
            ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>(2);
            futures.add(executorCompletionService.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    SemiAntiJoinIterator.this.advance(true);
                    return SemiAntiJoinIterator.this.lhsTuple == null;
                }
            }));
            futures.add(executorCompletionService.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    SemiAntiJoinIterator.this.advance(false);
                    return SemiAntiJoinIterator.this.rhsTuple == null && SemiAntiJoinIterator.this.isSemi;
                }
            }));
            try {
                Future future = executorCompletionService.take();
                if (((Boolean)future.get()).booleanValue()) {
                    this.joinResultNullBecauseOneSideNull = true;
                    this.initialized = true;
                    return;
                }
                future = executorCompletionService.take();
                if (((Boolean)future.get()).booleanValue()) {
                    this.joinResultNullBecauseOneSideNull = true;
                }
                this.initialized = true;
            }
            catch (Throwable throwable) {
                throw new SQLException("failed in init join iterators", throwable);
            }
            finally {
                SortMergeJoinPlan.clearThreadPoolExecutor(threadPoolExecutor, futures);
            }
        }

        @Override
        public Tuple next() throws SQLException {
            if (!this.initialized) {
                this.init();
            }
            if (this.joinResultNullBecauseOneSideNull) {
                return null;
            }
            Tuple next = null;
            while (next == null && !this.isEnd()) {
                if (this.rhsTuple != null) {
                    if (this.lhsKey.equals(this.rhsKey)) {
                        if (this.isSemi) {
                            next = this.lhsTuple;
                        }
                        this.advance(true);
                        continue;
                    }
                    if (this.lhsKey.compareTo(this.rhsKey) < 0) {
                        if (!this.isSemi) {
                            next = this.lhsTuple;
                        }
                        this.advance(true);
                        continue;
                    }
                    this.advance(false);
                    continue;
                }
                if (!this.isSemi) {
                    next = this.lhsTuple;
                }
                this.advance(true);
            }
            return next;
        }

        @VisibleForTesting
        public boolean isEnd() {
            return this.lhsTuple == null || this.rhsTuple == null && this.isSemi;
        }

        @Override
        public void explain(List<String> planSteps) {
        }

        @Override
        public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
        }

        private void advance(boolean lhs) throws SQLException {
            if (lhs) {
                this.lhsTuple = this.lhsIterator.next();
                if (this.lhsTuple != null) {
                    this.lhsKey.evaluate(this.lhsTuple);
                } else {
                    this.lhsKey.clear();
                }
            } else {
                this.rhsTuple = this.rhsIterator.next();
                if (this.rhsTuple != null) {
                    this.rhsKey.evaluate(this.rhsTuple);
                } else {
                    this.rhsKey.clear();
                }
            }
        }
    }

    @VisibleForTesting
    public class BasicJoinIterator
    implements ResultIterator {
        private final ResultIterator lhsIterator;
        private final ResultIterator rhsIterator;
        private boolean initialized;
        private Tuple lhsTuple;
        private Tuple rhsTuple;
        private JoinKey lhsKey;
        private JoinKey rhsKey;
        private Tuple nextLhsTuple;
        private Tuple nextRhsTuple;
        private JoinKey nextLhsKey;
        private JoinKey nextRhsKey;
        private ValueBitSet destBitSet;
        private ValueBitSet lhsBitSet;
        private ValueBitSet rhsBitSet;
        private byte[] emptyProjectedValue;
        private SizeAwareQueue<Tuple> queue;
        private Iterator<Tuple> queueIterator;
        private boolean joinResultNullBecauseOneSideNull = false;

        public BasicJoinIterator(ResultIterator lhsIterator, ResultIterator rhsIterator) {
            this.lhsIterator = lhsIterator;
            this.rhsIterator = rhsIterator;
            this.initialized = false;
            this.lhsTuple = null;
            this.rhsTuple = null;
            this.lhsKey = new JoinKey(SortMergeJoinPlan.this.lhsKeyExpressions);
            this.rhsKey = new JoinKey(SortMergeJoinPlan.this.rhsKeyExpressions);
            this.nextLhsTuple = null;
            this.nextRhsTuple = null;
            this.nextLhsKey = new JoinKey(SortMergeJoinPlan.this.lhsKeyExpressions);
            this.nextRhsKey = new JoinKey(SortMergeJoinPlan.this.rhsKeyExpressions);
            this.destBitSet = ValueBitSet.newInstance(SortMergeJoinPlan.this.joinedSchema);
            this.lhsBitSet = ValueBitSet.newInstance(SortMergeJoinPlan.this.lhsSchema);
            this.rhsBitSet = ValueBitSet.newInstance(SortMergeJoinPlan.this.rhsSchema);
            this.lhsBitSet.clear();
            int len = this.lhsBitSet.getEstimatedLength();
            this.emptyProjectedValue = new byte[len];
            this.lhsBitSet.toBytes(this.emptyProjectedValue, 0);
            this.queue = PhoenixQueues.newTupleQueue(SortMergeJoinPlan.this.spoolingEnabled, SortMergeJoinPlan.this.thresholdBytes);
            this.queueIterator = null;
        }

        public boolean isJoinResultNullBecauseOneSideNull() {
            return this.joinResultNullBecauseOneSideNull;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        @Override
        public void close() throws SQLException {
            SQLException sqlException = SortMergeJoinPlan.closeIterators(this.lhsIterator, this.rhsIterator);
            try {
                this.queue.close();
            }
            catch (IOException t) {
                if (sqlException != null) {
                    sqlException.setNextException(new SQLException("Also encountered exception while closing queue", t));
                }
                sqlException = new SQLException("Error while closing queue", t);
            }
            if (sqlException != null) {
                LOGGER.error("BasicJoinIterator close error!", (Throwable)sqlException);
            }
        }

        @Override
        public Tuple next() throws SQLException {
            if (!this.initialized) {
                this.init();
            }
            if (this.joinResultNullBecauseOneSideNull) {
                return null;
            }
            Tuple next = null;
            while (next == null && !this.isEnd()) {
                if (this.queueIterator != null) {
                    if (this.queueIterator.hasNext()) {
                        next = this.join(this.lhsTuple, this.queueIterator.next());
                        continue;
                    }
                    boolean eq = this.nextLhsTuple != null && this.lhsKey.equals(this.nextLhsKey);
                    this.advance(true);
                    if (eq) {
                        this.queueIterator = this.queue.iterator();
                        continue;
                    }
                    this.queue.clear();
                    this.queueIterator = null;
                    continue;
                }
                if (this.lhsTuple != null) {
                    if (this.rhsTuple != null) {
                        if (this.lhsKey.equals(this.rhsKey)) {
                            next = this.join(this.lhsTuple, this.rhsTuple);
                            if (this.nextLhsTuple != null && this.lhsKey.equals(this.nextLhsKey)) {
                                try {
                                    this.queue.add(this.rhsTuple);
                                }
                                catch (IllegalStateException e) {
                                    throw new PhoenixIOException(e);
                                }
                                if (this.nextRhsTuple == null || !this.rhsKey.equals(this.nextRhsKey)) {
                                    this.queueIterator = this.queue.iterator();
                                    this.advance(true);
                                } else if (SortMergeJoinPlan.this.isSingleValueOnly) {
                                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.SINGLE_ROW_SUBQUERY_RETURNS_MULTIPLE_ROWS).build().buildException();
                                }
                            } else if (this.nextRhsTuple == null || !this.rhsKey.equals(this.nextRhsKey)) {
                                this.advance(true);
                            } else if (SortMergeJoinPlan.this.isSingleValueOnly) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.SINGLE_ROW_SUBQUERY_RETURNS_MULTIPLE_ROWS).build().buildException();
                            }
                            this.advance(false);
                            continue;
                        }
                        if (this.lhsKey.compareTo(this.rhsKey) < 0) {
                            if (SortMergeJoinPlan.this.joinType == JoinTableNode.JoinType.Full || SortMergeJoinPlan.this.joinType == JoinTableNode.JoinType.Left) {
                                next = this.join(this.lhsTuple, null);
                            }
                            this.advance(true);
                            continue;
                        }
                        if (SortMergeJoinPlan.this.joinType == JoinTableNode.JoinType.Full) {
                            next = this.join(null, this.rhsTuple);
                        }
                        this.advance(false);
                        continue;
                    }
                    next = this.join(this.lhsTuple, null);
                    this.advance(true);
                    continue;
                }
                next = this.join(null, this.rhsTuple);
                this.advance(false);
            }
            return next;
        }

        @Override
        public void explain(List<String> planSteps) {
        }

        @Override
        public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
        }

        private void doInit(boolean lhs) throws SQLException {
            if (lhs) {
                this.nextLhsTuple = this.lhsIterator.next();
                if (this.nextLhsTuple != null) {
                    this.nextLhsKey.evaluate(this.nextLhsTuple);
                }
                this.advance(true);
            } else {
                this.nextRhsTuple = this.rhsIterator.next();
                if (this.nextRhsTuple != null) {
                    this.nextRhsKey.evaluate(this.nextRhsTuple);
                }
                this.advance(false);
            }
        }

        private void init() throws SQLException {
            ExecutorService threadPoolExecutor = Executors.newFixedThreadPool(2);
            ExecutorCompletionService<Boolean> executorCompletionService = new ExecutorCompletionService<Boolean>(threadPoolExecutor);
            ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>(2);
            futures.add(executorCompletionService.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    BasicJoinIterator.this.doInit(true);
                    return BasicJoinIterator.this.lhsTuple == null && (SortMergeJoinPlan.this.joinType == JoinTableNode.JoinType.Inner || SortMergeJoinPlan.this.joinType == JoinTableNode.JoinType.Left);
                }
            }));
            futures.add(executorCompletionService.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    BasicJoinIterator.this.doInit(false);
                    return BasicJoinIterator.this.rhsTuple == null && SortMergeJoinPlan.this.joinType == JoinTableNode.JoinType.Inner;
                }
            }));
            try {
                Future future = executorCompletionService.take();
                if (((Boolean)future.get()).booleanValue()) {
                    this.joinResultNullBecauseOneSideNull = true;
                    this.initialized = true;
                    return;
                }
                future = executorCompletionService.take();
                if (((Boolean)future.get()).booleanValue()) {
                    this.joinResultNullBecauseOneSideNull = true;
                }
                this.initialized = true;
            }
            catch (Throwable throwable) {
                throw new SQLException("failed in init join iterators", throwable);
            }
            finally {
                SortMergeJoinPlan.clearThreadPoolExecutor(threadPoolExecutor, futures);
            }
        }

        private void advance(boolean lhs) throws SQLException {
            if (lhs) {
                this.lhsTuple = this.nextLhsTuple;
                this.lhsKey.set(this.nextLhsKey);
                if (this.lhsTuple != null) {
                    this.nextLhsTuple = this.lhsIterator.next();
                    if (this.nextLhsTuple != null) {
                        this.nextLhsKey.evaluate(this.nextLhsTuple);
                    } else {
                        this.nextLhsKey.clear();
                    }
                }
            } else {
                this.rhsTuple = this.nextRhsTuple;
                this.rhsKey.set(this.nextRhsKey);
                if (this.rhsTuple != null) {
                    this.nextRhsTuple = this.rhsIterator.next();
                    if (this.nextRhsTuple != null) {
                        this.nextRhsKey.evaluate(this.nextRhsTuple);
                    } else {
                        this.nextRhsKey.clear();
                    }
                }
            }
        }

        private boolean isEnd() {
            return this.lhsTuple == null && (this.rhsTuple == null || SortMergeJoinPlan.this.joinType != JoinTableNode.JoinType.Full) || this.queueIterator == null && this.rhsTuple == null && SortMergeJoinPlan.this.joinType == JoinTableNode.JoinType.Inner;
        }

        private Tuple join(Tuple lhs, Tuple rhs) throws SQLException {
            try {
                TupleProjector.ProjectedValueTuple t = null;
                if (lhs == null) {
                    t = new TupleProjector.ProjectedValueTuple(rhs, rhs.getValue(0).getTimestamp(), this.emptyProjectedValue, 0, this.emptyProjectedValue.length, this.emptyProjectedValue.length);
                } else if (lhs instanceof TupleProjector.ProjectedValueTuple) {
                    t = (TupleProjector.ProjectedValueTuple)lhs;
                } else {
                    ImmutableBytesWritable ptr = SortMergeJoinPlan.this.context.getTempPtr();
                    TupleProjector.decodeProjectedValue(lhs, ptr);
                    this.lhsBitSet.clear();
                    this.lhsBitSet.or(ptr);
                    int bitSetLen = this.lhsBitSet.getEstimatedLength();
                    t = new TupleProjector.ProjectedValueTuple(lhs, lhs.getValue(0).getTimestamp(), ptr.get(), ptr.getOffset(), ptr.getLength(), bitSetLen);
                }
                return this.rhsBitSet == ValueBitSet.EMPTY_VALUE_BITSET ? t : TupleProjector.mergeProjectedValue(t, this.destBitSet, rhs, this.rhsBitSet, SortMergeJoinPlan.this.rhsFieldPosition, true);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
    }
}

