/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.collect.MinMaxPriorityQueue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.iterate.BufferedQueue;
import org.apache.phoenix.iterate.OrderedResultIterator;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ResultUtil;

public class BufferedSortedQueue
extends BufferedQueue<OrderedResultIterator.ResultEntry> {
    private Comparator<OrderedResultIterator.ResultEntry> comparator;
    private final int limit;

    public BufferedSortedQueue(Comparator<OrderedResultIterator.ResultEntry> comparator, Integer limit, long thresholdBytes) throws IOException {
        super(thresholdBytes);
        this.comparator = comparator;
        this.limit = limit == null ? -1 : limit;
    }

    @Override
    protected BufferedQueue.BufferedSegmentQueue<OrderedResultIterator.ResultEntry> createSegmentQueue(int index, long thresholdBytes) {
        return new BufferedResultEntryPriorityQueue(index, thresholdBytes, this.limit, this.comparator);
    }

    @Override
    protected Comparator<BufferedQueue.BufferedSegmentQueue<OrderedResultIterator.ResultEntry>> getSegmentQueueComparator() {
        return new Comparator<BufferedQueue.BufferedSegmentQueue<OrderedResultIterator.ResultEntry>>(){

            @Override
            public int compare(BufferedQueue.BufferedSegmentQueue<OrderedResultIterator.ResultEntry> q1, BufferedQueue.BufferedSegmentQueue<OrderedResultIterator.ResultEntry> q2) {
                return BufferedSortedQueue.this.comparator.compare(q1.peek(), q2.peek());
            }
        };
    }

    private static class BufferedResultEntryPriorityQueue
    extends BufferedQueue.BufferedSegmentQueue<OrderedResultIterator.ResultEntry> {
        private MinMaxPriorityQueue<OrderedResultIterator.ResultEntry> results = null;

        public BufferedResultEntryPriorityQueue(int index, long thresholdBytes, int limit, Comparator<OrderedResultIterator.ResultEntry> comparator) {
            super(index, thresholdBytes, limit >= 0);
            this.results = limit < 0 ? MinMaxPriorityQueue.orderedBy(comparator).create() : MinMaxPriorityQueue.orderedBy(comparator).maximumSize(limit).create();
        }

        @Override
        protected Queue<OrderedResultIterator.ResultEntry> getInMemoryQueue() {
            return this.results;
        }

        @Override
        protected long sizeOf(OrderedResultIterator.ResultEntry e) {
            return OrderedResultIterator.ResultEntry.sizeOf(e);
        }

        @Override
        protected void writeToStream(DataOutputStream os, OrderedResultIterator.ResultEntry e) throws IOException {
            int totalLen = 0;
            List<KeyValue> keyValues = this.toKeyValues(e);
            for (KeyValue kv : keyValues) {
                totalLen += kv.getLength() + 4;
            }
            os.writeInt(totalLen);
            for (KeyValue kv : keyValues) {
                os.writeInt(kv.getLength());
                os.write(kv.getBuffer(), kv.getOffset(), kv.getLength());
            }
            ImmutableBytesWritable[] sortKeys = e.sortKeys;
            os.writeInt(sortKeys.length);
            for (ImmutableBytesWritable sortKey : sortKeys) {
                if (sortKey != null) {
                    os.writeInt(sortKey.getLength());
                    os.write(sortKey.get(), sortKey.getOffset(), sortKey.getLength());
                    continue;
                }
                os.writeInt(0);
            }
        }

        @Override
        protected OrderedResultIterator.ResultEntry readFromStream(DataInputStream is) throws IOException {
            int length = is.readInt();
            if (length < 0) {
                return null;
            }
            byte[] rb = new byte[length];
            is.readFully(rb);
            Result result = ResultUtil.toResult(new ImmutableBytesWritable(rb));
            ResultTuple rt = new ResultTuple(result);
            int sortKeySize = is.readInt();
            ImmutableBytesWritable[] sortKeys = new ImmutableBytesWritable[sortKeySize];
            for (int i = 0; i < sortKeySize; ++i) {
                int contentLength = is.readInt();
                if (contentLength > 0) {
                    byte[] sortKeyContent = new byte[contentLength];
                    is.readFully(sortKeyContent);
                    sortKeys[i] = new ImmutableBytesWritable(sortKeyContent);
                    continue;
                }
                sortKeys[i] = null;
            }
            return new OrderedResultIterator.ResultEntry(sortKeys, rt);
        }

        private List<KeyValue> toKeyValues(OrderedResultIterator.ResultEntry entry) {
            Tuple result = entry.getResult();
            int size = result.size();
            ArrayList<KeyValue> kvs = new ArrayList<KeyValue>(size);
            for (int i = 0; i < size; ++i) {
                kvs.add(KeyValueUtil.ensureKeyValue((Cell)result.getValue(i)));
            }
            return kvs;
        }
    }
}

