/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.collect.Lists;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.iterate.BufferedQueue;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ResultUtil;

public class BufferedTupleQueue
extends BufferedQueue<Tuple> {
    public BufferedTupleQueue(long thresholdBytes) {
        super(thresholdBytes);
    }

    @Override
    protected BufferedQueue.BufferedSegmentQueue<Tuple> createSegmentQueue(int index, long thresholdBytes) {
        return new BufferedTupleSegmentQueue(index, thresholdBytes, false);
    }

    @Override
    protected Comparator<BufferedQueue.BufferedSegmentQueue<Tuple>> getSegmentQueueComparator() {
        return new Comparator<BufferedQueue.BufferedSegmentQueue<Tuple>>(){

            @Override
            public int compare(BufferedQueue.BufferedSegmentQueue<Tuple> q1, BufferedQueue.BufferedSegmentQueue<Tuple> q2) {
                return q1.index() - q2.index();
            }
        };
    }

    @Override
    public Iterator<Tuple> iterator() {
        return new Iterator<Tuple>(){
            private Iterator<BufferedQueue.BufferedSegmentQueue<Tuple>> queueIter;
            private Iterator<Tuple> currentIter;
            {
                this.queueIter = BufferedTupleQueue.this.getSegmentQueues().iterator();
                this.currentIter = this.queueIter.hasNext() ? this.queueIter.next().iterator() : null;
            }

            @Override
            public boolean hasNext() {
                return this.currentIter != null && this.currentIter.hasNext();
            }

            @Override
            public Tuple next() {
                if (!this.hasNext()) {
                    return null;
                }
                Tuple ret = this.currentIter.next();
                if (!this.currentIter.hasNext()) {
                    this.currentIter = this.queueIter.hasNext() ? this.queueIter.next().iterator() : null;
                }
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class BufferedTupleSegmentQueue
    extends BufferedQueue.BufferedSegmentQueue<Tuple> {
        private LinkedList<Tuple> results = Lists.newLinkedList();

        public BufferedTupleSegmentQueue(int index, long thresholdBytes, boolean hasMaxQueueSize) {
            super(index, thresholdBytes, hasMaxQueueSize);
        }

        @Override
        protected Queue<Tuple> getInMemoryQueue() {
            return this.results;
        }

        @Override
        protected long sizeOf(Tuple e) {
            KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)e.getValue(0));
            return 8 + kv.getLength();
        }

        @Override
        protected void writeToStream(DataOutputStream out, Tuple e) throws IOException {
            KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)e.getValue(0));
            out.writeInt(kv.getLength() + 4);
            out.writeInt(kv.getLength());
            out.write(kv.getBuffer(), kv.getOffset(), kv.getLength());
        }

        @Override
        protected Tuple readFromStream(DataInputStream in) throws IOException {
            int length = in.readInt();
            if (length < 0) {
                return null;
            }
            byte[] b = new byte[length];
            in.readFully(b);
            Result result = ResultUtil.toResult(new ImmutableBytesWritable(b));
            return new ResultTuple(result);
        }
    }
}

