/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.Aggregators;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.iterate.AggregatingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.SizedUtil;
import org.apache.phoenix.util.TupleUtil;

public class ClientHashAggregatingResultIterator
implements AggregatingResultIterator {
    private static final int HASH_AGG_INIT_SIZE = 65536;
    private static final int CLIENT_HASH_AGG_MEMORY_CHUNK_SIZE = 65536;
    private static final byte[] UNITIALIZED_KEY_BUFFER = new byte[0];
    private final ResultIterator resultIterator;
    private final Aggregators aggregators;
    private final List<Expression> groupByExpressions;
    private final OrderByCompiler.OrderBy orderBy;
    private final MemoryManager.MemoryChunk memoryChunk;
    private HashMap<ImmutableBytesWritable, Aggregator[]> hash;
    private List<ImmutableBytesWritable> keyList;
    private Iterator<ImmutableBytesWritable> keyIterator;

    public ClientHashAggregatingResultIterator(StatementContext context, ResultIterator resultIterator, Aggregators aggregators, List<Expression> groupByExpressions, OrderByCompiler.OrderBy orderBy) {
        Objects.requireNonNull(resultIterator);
        Objects.requireNonNull(aggregators);
        Objects.requireNonNull(groupByExpressions);
        this.resultIterator = resultIterator;
        this.aggregators = aggregators;
        this.groupByExpressions = groupByExpressions;
        this.orderBy = orderBy;
        this.memoryChunk = context.getConnection().getQueryServices().getMemoryManager().allocate(65536L);
    }

    @Override
    public Tuple next() throws SQLException {
        if (this.keyIterator == null) {
            this.hash = this.populateHash();
            if (this.orderBy == OrderByCompiler.OrderBy.FWD_ROW_KEY_ORDER_BY || this.orderBy == OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY) {
                this.keyList = this.sortKeys();
                this.keyIterator = this.keyList.iterator();
            } else {
                this.keyIterator = this.hash.keySet().iterator();
            }
        }
        if (!this.keyIterator.hasNext()) {
            return null;
        }
        ImmutableBytesWritable key = this.keyIterator.next();
        Aggregator[] rowAggregators = this.hash.get(key);
        byte[] value = this.aggregators.toBytes(rowAggregators);
        Tuple tuple = this.wrapKeyValueAsResult(KeyValueUtil.newKeyValue(key, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, value, 0, value.length));
        return tuple;
    }

    @Override
    public void close() throws SQLException {
        this.keyIterator = null;
        this.keyList = null;
        this.hash = null;
        try {
            this.memoryChunk.close();
        }
        finally {
            this.resultIterator.close();
        }
    }

    @Override
    public Aggregator[] aggregate(Tuple result) {
        Aggregator[] rowAggregators = this.aggregators.getAggregators();
        this.aggregators.reset(rowAggregators);
        this.aggregators.aggregate(rowAggregators, result);
        return rowAggregators;
    }

    @Override
    public void explain(List<String> planSteps) {
        this.resultIterator.explain(planSteps);
    }

    @Override
    public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
        this.resultIterator.explain(planSteps, explainPlanAttributesBuilder);
    }

    public String toString() {
        return "ClientHashAggregatingResultIterator [resultIterator=" + this.resultIterator + ", aggregators=" + this.aggregators + ", groupByExpressions=" + this.groupByExpressions + "]";
    }

    protected ImmutableBytesWritable getGroupingKey(Tuple tuple, ImmutableBytesWritable ptr) throws SQLException {
        try {
            ImmutableBytesPtr key = TupleUtil.getConcatenatedValue(tuple, this.groupByExpressions);
            ptr.set(key.get(), key.getOffset(), key.getLength());
            return ptr;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    protected Tuple wrapKeyValueAsResult(KeyValue keyValue) {
        return new MultiKeyValueTuple(Collections.singletonList(keyValue));
    }

    private HashMap<ImmutableBytesWritable, Aggregator[]> populateHash() throws SQLException {
        this.hash = new HashMap(65536, 0.75f);
        int aggSize = this.aggregators.getEstimatedByteSize();
        long keySize = 0L;
        Tuple result = this.resultIterator.next();
        while (result != null) {
            ImmutableBytesWritable key = new ImmutableBytesWritable(UNITIALIZED_KEY_BUFFER);
            Aggregator[] rowAggregators = this.hash.get(key = this.getGroupingKey(result, key));
            if (rowAggregators == null) {
                long hashSize = SizedUtil.sizeOfMap(this.hash.size() + 1, 48, aggSize) + (keySize += (long)key.getSize());
                if (hashSize > this.memoryChunk.getSize() + 65536L) {
                    this.memoryChunk.resize(hashSize + 65536L);
                }
                rowAggregators = this.aggregators.newAggregators();
                this.hash.put(key, rowAggregators);
            }
            this.aggregators.aggregate(rowAggregators, result);
            result = this.resultIterator.next();
        }
        return this.hash;
    }

    private List<ImmutableBytesWritable> sortKeys() {
        this.memoryChunk.resize(this.memoryChunk.getSize() + (long)SizedUtil.sizeOfArrayList(this.hash.size()));
        this.keyList = new ArrayList<ImmutableBytesWritable>(this.hash.size());
        this.keyList.addAll(this.hash.keySet());
        Object comp = new ImmutableBytesWritable.Comparator();
        if (this.orderBy == OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY) {
            comp = Collections.reverseOrder(comp);
        }
        Collections.sort(this.keyList, comp);
        return this.keyList;
    }
}

