/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.iterate.DelegateResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ScanUtil;

public class OffsetResultIterator
extends DelegateResultIterator {
    private int rowCount;
    private int offset;
    private long pageSizeMs = Long.MAX_VALUE;

    public OffsetResultIterator(ResultIterator delegate, Integer offset) {
        super(delegate);
        this.offset = offset == null ? -1 : offset;
    }

    public OffsetResultIterator(ResultIterator delegate, Integer offset, long pageSizeMs) {
        this(delegate, offset);
        this.pageSizeMs = pageSizeMs;
    }

    @Override
    public Tuple next() throws SQLException {
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        while (this.rowCount < this.offset) {
            Tuple tuple = super.next();
            if (tuple == null) {
                return null;
            }
            ++this.rowCount;
            if (EnvironmentEdgeManager.currentTimeMillis() - startTime < this.pageSizeMs) continue;
            return ScanUtil.getDummyTuple(tuple);
        }
        return super.next();
    }

    @Override
    public void explain(List<String> planSteps) {
        super.explain(planSteps);
        planSteps.add("CLIENT OFFSET " + this.offset);
    }

    @Override
    public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
        super.explain(planSteps, explainPlanAttributesBuilder);
        explainPlanAttributesBuilder.setClientOffset(this.offset);
        planSteps.add("CLIENT OFFSET " + this.offset);
    }

    public String toString() {
        return "OffsetResultIterator [rowCount=" + this.rowCount + ", offset=" + this.offset + "]";
    }

    public Integer getRemainingOffset() {
        return this.offset - this.rowCount > 0 ? this.offset - this.rowCount : 0;
    }
}

