/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.hadoop.hbase.util.Bytes;

public final class GuidePostsKey {
    private final int hashCode;
    @Nonnull
    private final byte[] physicalName;
    @Nonnull
    private final byte[] columnFamily;

    public GuidePostsKey(byte[] physicalName, byte[] columnFamily) {
        Preconditions.checkNotNull((Object)physicalName);
        Preconditions.checkNotNull((Object)columnFamily);
        this.physicalName = physicalName;
        this.columnFamily = columnFamily;
        this.hashCode = this.computeHashCode();
    }

    public byte[] getPhysicalName() {
        return this.physicalName;
    }

    public byte[] getColumnFamily() {
        return this.columnFamily;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.columnFamily);
        result = 31 * result + Arrays.hashCode(this.physicalName);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GuidePostsKey other = (GuidePostsKey)obj;
        if (other.hashCode != this.hashCode) {
            return false;
        }
        if (!Arrays.equals(this.columnFamily, other.columnFamily)) {
            return false;
        }
        return Arrays.equals(this.physicalName, other.physicalName);
    }

    public String toString() {
        return "GuidePostsKey[physicalName=" + Bytes.toStringBinary((byte[])this.physicalName) + ",columnFamily=" + Bytes.toStringBinary((byte[])this.columnFamily) + "]";
    }
}

