/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.util.SchemaUtil;

public class QueryBuilder {
    private String fullTableName;
    private List<String> selectColumns = Collections.emptyList();
    private List<String> selectExpressionColumns = Collections.emptyList();
    private String selectExpression;
    private String whereClause;
    private String orderByClause;
    private String groupByClause;
    private String havingClause;
    private HintNode.Hint hint;
    private boolean escapeCols;
    private boolean distinct;
    private int limit;

    public String getFullTableName() {
        return this.fullTableName;
    }

    public List<String> getRequiredColumns() {
        ArrayList allColumns = Lists.newArrayList(this.selectColumns);
        if (!CollectionUtils.isEmpty(this.selectExpressionColumns)) {
            allColumns.addAll(this.selectExpressionColumns);
        }
        return allColumns;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public HintNode.Hint getHint() {
        return this.hint;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public String getGroupByClause() {
        return this.groupByClause;
    }

    public QueryBuilder setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
        return this;
    }

    public QueryBuilder setFullTableName(String fullTableName) {
        this.fullTableName = fullTableName;
        return this;
    }

    public QueryBuilder setSelectColumns(List<String> columns) {
        this.selectColumns = columns;
        return this;
    }

    public QueryBuilder setWhereClause(String whereClause) {
        this.whereClause = whereClause;
        return this;
    }

    public QueryBuilder setHint(HintNode.Hint hint) {
        this.hint = hint;
        return this;
    }

    public QueryBuilder setEscapeCols(boolean escapeCols) {
        this.escapeCols = escapeCols;
        return this;
    }

    public QueryBuilder setGroupByClause(String groupByClause) {
        this.groupByClause = groupByClause;
        return this;
    }

    public QueryBuilder setHavingClause(String havingClause) {
        this.havingClause = havingClause;
        return this;
    }

    public List<String> getSelectExpressionColumns() {
        return this.selectExpressionColumns;
    }

    public QueryBuilder setSelectExpressionColumns(List<String> selectExpressionColumns) {
        this.selectExpressionColumns = selectExpressionColumns;
        return this;
    }

    public String getSelectExpression() {
        return this.selectExpression;
    }

    public QueryBuilder setSelectExpression(String selectExpression) {
        this.selectExpression = selectExpression;
        return this;
    }

    public QueryBuilder setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public QueryBuilder setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public String build() {
        Preconditions.checkNotNull((Object)this.fullTableName, (Object)"Table name cannot be null");
        if (CollectionUtils.isEmpty(this.selectColumns) && StringUtils.isBlank((String)this.selectExpression)) {
            throw new IllegalArgumentException("At least one column or select expression must be provided");
        }
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        if (this.distinct) {
            query.append(" DISTINCT ");
        }
        if (this.hint != null) {
            HintNode node = new HintNode(this.hint.name());
            String hintStr = node.toString();
            query.append(hintStr);
        }
        StringBuilder selectClauseBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((String)this.selectExpression)) {
            if (selectClauseBuilder.length() != 0) {
                selectClauseBuilder.append(" , ");
            }
            selectClauseBuilder.append(this.selectExpression);
        }
        boolean first = true;
        for (String col : this.selectColumns) {
            if (!StringUtils.isNotBlank((String)col)) continue;
            if (first && selectClauseBuilder.length() != 0 || !first) {
                selectClauseBuilder.append(" , ");
            }
            String fullColumnName = col;
            if (this.escapeCols) {
                fullColumnName = SchemaUtil.getEscapedFullColumnName(col);
            }
            selectClauseBuilder.append(fullColumnName);
            first = false;
        }
        query.append((CharSequence)selectClauseBuilder);
        query.append(" FROM ");
        query.append(this.fullTableName);
        if (StringUtils.isNotBlank((String)this.whereClause)) {
            query.append(" WHERE (").append(this.whereClause).append(")");
        }
        if (StringUtils.isNotBlank((String)this.groupByClause)) {
            query.append(" GROUP BY ").append(this.groupByClause);
        }
        if (StringUtils.isNotBlank((String)this.havingClause)) {
            query.append(" HAVING ").append(this.havingClause);
        }
        if (StringUtils.isNotBlank((String)this.orderByClause)) {
            query.append(" ORDER BY ").append(this.orderByClause);
        }
        if (this.limit > 0) {
            query.append(" LIMIT ").append(this.limit);
        }
        return query.toString();
    }
}

