/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Service;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.twill.api.RunId;
import org.apache.twill.common.Cancellable;
import org.apache.twill.common.Threads;
import org.apache.twill.internal.state.Message;
import org.apache.twill.internal.state.MessageCallback;
import org.apache.twill.internal.state.MessageCodec;
import org.apache.twill.internal.state.SystemMessages;
import org.apache.twill.zookeeper.NodeChildren;
import org.apache.twill.zookeeper.NodeData;
import org.apache.twill.zookeeper.OperationFuture;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.twill.zookeeper.ZKOperations;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTwillService
extends AbstractExecutionThreadService
implements MessageCallback {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTwillService.class);
    private static final Gson GSON = new Gson();
    protected final ZKClient zkClient;
    protected final RunId runId;
    private ExecutorService messageCallbackExecutor;
    private Cancellable watcherCancellable;

    protected AbstractTwillService(ZKClient zkClient, RunId runId) {
        this.zkClient = zkClient;
        this.runId = runId;
    }

    protected void doStart() throws Exception {
    }

    protected void doRun() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    protected Object getLiveNodeData() {
        return null;
    }

    @Override
    public ListenableFuture<String> onReceived(String messageId, Message message) {
        LOG.info("Message received: {}", (Object)message);
        return Futures.immediateCheckedFuture((Object)messageId);
    }

    protected final void startUp() throws Exception {
        this.messageCallbackExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), Threads.createDaemonThreadFactory("message-callback"), new ThreadPoolExecutor.DiscardPolicy());
        this.watcherCancellable = this.zkClient.addConnectionWatcher(new Watcher(){
            private boolean expired = false;

            public void process(WatchedEvent event) {
                if (event.getState() == Watcher.Event.KeeperState.Expired) {
                    LOG.warn("ZK Session expired for service {} with runId {}.", (Object)AbstractTwillService.this.getServiceName(), (Object)AbstractTwillService.this.runId.getId());
                    this.expired = true;
                } else if (event.getState() == Watcher.Event.KeeperState.SyncConnected && this.expired) {
                    LOG.info("Reconnected after expiration for service {} with runId {}", (Object)AbstractTwillService.this.getServiceName(), (Object)AbstractTwillService.this.runId.getId());
                    this.expired = false;
                    AbstractTwillService.this.logIfFailed(AbstractTwillService.this.createLiveNode());
                }
            }
        });
        this.createLiveNode().get();
        ZKOperations.ignoreError(this.zkClient.create(this.getZKPath("messages"), null, CreateMode.PERSISTENT), KeeperException.NodeExistsException.class, null).get();
        this.doStart();
        this.watchMessages();
    }

    protected final void run() throws Exception {
        this.doRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void shutDown() throws Exception {
        if (this.watcherCancellable != null) {
            this.watcherCancellable.cancel();
        }
        this.messageCallbackExecutor.shutdownNow();
        try {
            this.doStop();
        }
        finally {
            this.removeLiveNode().get(5L, TimeUnit.SECONDS);
            LOG.info("Service {} with runId {} shutdown completed", (Object)this.getServiceName(), (Object)this.runId.getId());
        }
    }

    private OperationFuture<String> createLiveNode() {
        String liveNode = this.getLiveNodePath();
        LOG.info("Create live node {}{}", (Object)this.zkClient.getConnectString(), (Object)liveNode);
        JsonObject content = new JsonObject();
        Object liveNodeData = this.getLiveNodeData();
        if (liveNodeData != null) {
            content.add("data", GSON.toJsonTree(liveNodeData));
        }
        return ZKOperations.ignoreError(this.zkClient.create(liveNode, this.toJson(content), CreateMode.EPHEMERAL), KeeperException.NodeExistsException.class, liveNode);
    }

    private OperationFuture<String> removeLiveNode() {
        String liveNode = this.getLiveNodePath();
        LOG.info("Remove live node {}{}", (Object)this.zkClient.getConnectString(), (Object)liveNode);
        return ZKOperations.ignoreError(this.zkClient.delete(liveNode), KeeperException.NoNodeException.class, liveNode);
    }

    private void watchMessages() {
        final String messagesPath = this.getZKPath("messages");
        Futures.addCallback(this.zkClient.getChildren(messagesPath, new Watcher(){

            public void process(WatchedEvent event) {
                if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged && AbstractTwillService.this.isRunning()) {
                    AbstractTwillService.this.watchMessages();
                }
            }
        }), (FutureCallback)new FutureCallback<NodeChildren>(){

            public void onSuccess(NodeChildren result) {
                ArrayList messages = Lists.newArrayList(result.getChildren());
                Collections.sort(messages);
                for (String messageId : messages) {
                    AbstractTwillService.this.processMessage(messagesPath + "/" + messageId, messageId);
                }
            }

            public void onFailure(Throwable t) {
                LOG.error("Failed to watch messages.", t);
            }
        }, (Executor)Threads.SAME_THREAD_EXECUTOR);
    }

    private void processMessage(final String path, final String messageId) {
        Futures.addCallback(this.zkClient.getData(path), (FutureCallback)new FutureCallback<NodeData>(){

            public void onSuccess(NodeData result) {
                Runnable messageRemover = AbstractTwillService.this.createMessageRemover(path, result.getStat().getVersion());
                Message message = MessageCodec.decode(result.getData());
                if (message == null) {
                    LOG.error("Failed to decode message for {} in {}", (Object)messageId, (Object)path);
                    messageRemover.run();
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Message received from {}: {}", (Object)path, (Object)new String(MessageCodec.encode(message), Charsets.UTF_8));
                }
                if (AbstractTwillService.this.handleStopMessage(message, messageRemover)) {
                    return;
                }
                AbstractTwillService.this.handleMessage(messageId, message, messageRemover);
            }

            public void onFailure(Throwable t) {
                LOG.error("Failed to fetch message content from {}", (Object)path, (Object)t);
            }
        }, (Executor)this.messageCallbackExecutor);
    }

    private boolean handleStopMessage(Message message, final Runnable messageRemover) {
        if (message.getType() != Message.Type.SYSTEM || !SystemMessages.STOP_COMMAND.equals(message.getCommand())) {
            return false;
        }
        Futures.addCallback((ListenableFuture)this.stop(), (FutureCallback)new FutureCallback<Service.State>(){

            public void onSuccess(Service.State result) {
                messageRemover.run();
            }

            public void onFailure(Throwable t) {
                LOG.error("Stop service failed upon STOP command", t);
                messageRemover.run();
            }
        }, (Executor)Threads.SAME_THREAD_EXECUTOR);
        return true;
    }

    private void handleMessage(String messageId, final Message message, final Runnable messageRemover) {
        Futures.addCallback(this.onReceived(messageId, message), (FutureCallback)new FutureCallback<String>(){

            public void onSuccess(String result) {
                messageRemover.run();
            }

            public void onFailure(Throwable t) {
                LOG.error("Failed to handle message {}", (Object)message, (Object)t);
                messageRemover.run();
            }
        }, (Executor)Threads.SAME_THREAD_EXECUTOR);
    }

    private Runnable createMessageRemover(final String path, final int version) {
        return new Runnable(){

            @Override
            public void run() {
                AbstractTwillService.this.logIfFailed(AbstractTwillService.this.zkClient.delete(path, version));
            }
        };
    }

    private <T> void logIfFailed(ListenableFuture<T> future) {
        Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
            }

            public void onFailure(Throwable t) {
                LOG.error("Operation failed for service {} with runId {}", new Object[]{AbstractTwillService.this.getServiceName(), AbstractTwillService.this.runId, t});
            }
        }, (Executor)Threads.SAME_THREAD_EXECUTOR);
    }

    private String getZKPath(String path) {
        return String.format("/%s/%s", this.runId.getId(), path);
    }

    private String getLiveNodePath() {
        return String.format("%s/%s", "/instances", this.runId.getId());
    }

    private <T> byte[] toJson(T obj) {
        return GSON.toJson(obj).getBytes(Charsets.UTF_8);
    }
}

