/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload.mt.generators;

import java.util.List;
import java.util.Properties;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.mt.generators.LoadEventGenerator;
import org.apache.phoenix.pherf.workload.mt.generators.LoadEventGeneratorFactory;
import org.apache.phoenix.pherf.workload.mt.generators.SequentialLoadEventGenerator;
import org.apache.phoenix.pherf.workload.mt.generators.TenantOperationInfo;
import org.apache.phoenix.pherf.workload.mt.generators.UniformDistributionLoadEventGenerator;
import org.apache.phoenix.pherf.workload.mt.generators.WeightedRandomLoadEventGenerator;
import org.apache.phoenix.pherf.workload.mt.handlers.PherfWorkHandler;

public class TenantLoadEventGeneratorFactory
implements LoadEventGeneratorFactory<TenantOperationInfo> {
    @Override
    public LoadEventGenerator<TenantOperationInfo> newLoadEventGenerator(PhoenixUtil phoenixUtil, DataModel model, Scenario scenario, Properties properties) {
        GeneratorType type = GeneratorType.valueOf(scenario.getGeneratorName());
        switch (type) {
            case WEIGHTED: {
                return new WeightedRandomLoadEventGenerator(phoenixUtil, model, scenario, properties);
            }
            case UNIFORM: {
                return new UniformDistributionLoadEventGenerator(phoenixUtil, model, scenario, properties);
            }
            case SEQUENTIAL: {
                return new SequentialLoadEventGenerator(phoenixUtil, model, scenario, properties);
            }
        }
        throw new IllegalArgumentException("Unknown generator type");
    }

    @Override
    public LoadEventGenerator<TenantOperationInfo> newLoadEventGenerator(PhoenixUtil phoenixUtil, DataModel model, Scenario scenario, List<PherfWorkHandler> workHandlers, Properties properties) {
        GeneratorType type = GeneratorType.valueOf(scenario.getGeneratorName());
        switch (type) {
            case WEIGHTED: {
                return new WeightedRandomLoadEventGenerator(phoenixUtil, model, scenario, workHandlers, properties);
            }
            case UNIFORM: {
                return new UniformDistributionLoadEventGenerator(phoenixUtil, model, scenario, workHandlers, properties);
            }
            case SEQUENTIAL: {
                return new SequentialLoadEventGenerator(phoenixUtil, model, scenario, workHandlers, properties);
            }
        }
        throw new IllegalArgumentException("Unknown generator type");
    }

    public static enum GeneratorType {
        WEIGHTED,
        UNIFORM,
        SEQUENTIAL;

    }
}

