/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetLiftCarDoorCommandTagged is the corresponding interface of BACnetLiftCarDoorCommandTagged
type BACnetLiftCarDoorCommandTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetLiftCarDoorCommand
	// IsBACnetLiftCarDoorCommandTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetLiftCarDoorCommandTagged()
	// CreateBuilder creates a BACnetLiftCarDoorCommandTaggedBuilder
	CreateBACnetLiftCarDoorCommandTaggedBuilder() BACnetLiftCarDoorCommandTaggedBuilder
}

// _BACnetLiftCarDoorCommandTagged is the data-structure of this message
type _BACnetLiftCarDoorCommandTagged struct {
	Header BACnetTagHeader
	Value  BACnetLiftCarDoorCommand

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetLiftCarDoorCommandTagged = (*_BACnetLiftCarDoorCommandTagged)(nil)

// NewBACnetLiftCarDoorCommandTagged factory function for _BACnetLiftCarDoorCommandTagged
func NewBACnetLiftCarDoorCommandTagged(header BACnetTagHeader, value BACnetLiftCarDoorCommand, tagNumber uint8, tagClass TagClass) *_BACnetLiftCarDoorCommandTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetLiftCarDoorCommandTagged must not be nil")
	}
	return &_BACnetLiftCarDoorCommandTagged{Header: header, Value: value, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetLiftCarDoorCommandTaggedBuilder is a builder for BACnetLiftCarDoorCommandTagged
type BACnetLiftCarDoorCommandTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetLiftCarDoorCommand) BACnetLiftCarDoorCommandTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetLiftCarDoorCommandTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetLiftCarDoorCommandTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetLiftCarDoorCommand) BACnetLiftCarDoorCommandTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetLiftCarDoorCommandTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetLiftCarDoorCommandTaggedBuilder
	// Build builds the BACnetLiftCarDoorCommandTagged or returns an error if something is wrong
	Build() (BACnetLiftCarDoorCommandTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetLiftCarDoorCommandTagged
}

// NewBACnetLiftCarDoorCommandTaggedBuilder() creates a BACnetLiftCarDoorCommandTaggedBuilder
func NewBACnetLiftCarDoorCommandTaggedBuilder() BACnetLiftCarDoorCommandTaggedBuilder {
	return &_BACnetLiftCarDoorCommandTaggedBuilder{_BACnetLiftCarDoorCommandTagged: new(_BACnetLiftCarDoorCommandTagged)}
}

type _BACnetLiftCarDoorCommandTaggedBuilder struct {
	*_BACnetLiftCarDoorCommandTagged

	collectedErr []error
}

var _ (BACnetLiftCarDoorCommandTaggedBuilder) = (*_BACnetLiftCarDoorCommandTaggedBuilder)(nil)

func (b *_BACnetLiftCarDoorCommandTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetLiftCarDoorCommand) BACnetLiftCarDoorCommandTaggedBuilder {
	return b.WithHeader(header).WithValue(value)
}

func (b *_BACnetLiftCarDoorCommandTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetLiftCarDoorCommandTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetLiftCarDoorCommandTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetLiftCarDoorCommandTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetLiftCarDoorCommandTaggedBuilder) WithValue(value BACnetLiftCarDoorCommand) BACnetLiftCarDoorCommandTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetLiftCarDoorCommandTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetLiftCarDoorCommandTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetLiftCarDoorCommandTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetLiftCarDoorCommandTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetLiftCarDoorCommandTaggedBuilder) Build() (BACnetLiftCarDoorCommandTagged, error) {
	if b.Header == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'header' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetLiftCarDoorCommandTagged.deepCopy(), nil
}

func (b *_BACnetLiftCarDoorCommandTaggedBuilder) MustBuild() BACnetLiftCarDoorCommandTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetLiftCarDoorCommandTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetLiftCarDoorCommandTaggedBuilder().(*_BACnetLiftCarDoorCommandTaggedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetLiftCarDoorCommandTaggedBuilder creates a BACnetLiftCarDoorCommandTaggedBuilder
func (b *_BACnetLiftCarDoorCommandTagged) CreateBACnetLiftCarDoorCommandTaggedBuilder() BACnetLiftCarDoorCommandTaggedBuilder {
	if b == nil {
		return NewBACnetLiftCarDoorCommandTaggedBuilder()
	}
	return &_BACnetLiftCarDoorCommandTaggedBuilder{_BACnetLiftCarDoorCommandTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetLiftCarDoorCommandTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetLiftCarDoorCommandTagged) GetValue() BACnetLiftCarDoorCommand {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetLiftCarDoorCommandTagged(structType any) BACnetLiftCarDoorCommandTagged {
	if casted, ok := structType.(BACnetLiftCarDoorCommandTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetLiftCarDoorCommandTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetLiftCarDoorCommandTagged) GetTypeName() string {
	return "BACnetLiftCarDoorCommandTagged"
}

func (m *_BACnetLiftCarDoorCommandTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(int32(m.GetHeader().GetActualLength()) * int32(int32(8)))

	return lengthInBits
}

func (m *_BACnetLiftCarDoorCommandTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetLiftCarDoorCommandTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetLiftCarDoorCommandTagged, error) {
	return BACnetLiftCarDoorCommandTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetLiftCarDoorCommandTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLiftCarDoorCommandTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLiftCarDoorCommandTagged, error) {
		return BACnetLiftCarDoorCommandTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetLiftCarDoorCommandTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetLiftCarDoorCommandTagged, error) {
	v, err := (&_BACnetLiftCarDoorCommandTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetLiftCarDoorCommandTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetLiftCarDoorCommandTagged BACnetLiftCarDoorCommandTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetLiftCarDoorCommandTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetLiftCarDoorCommandTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetLiftCarDoorCommand](ctx, "value", readBuffer, EnsureType[BACnetLiftCarDoorCommand](ReadEnumGenericFailing(ctx, readBuffer, header.GetActualLength(), BACnetLiftCarDoorCommand_NONE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("BACnetLiftCarDoorCommandTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetLiftCarDoorCommandTagged")
	}

	return m, nil
}

func (m *_BACnetLiftCarDoorCommandTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetLiftCarDoorCommandTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetLiftCarDoorCommandTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetLiftCarDoorCommandTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetLiftCarDoorCommand](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if popErr := writeBuffer.PopContext("BACnetLiftCarDoorCommandTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetLiftCarDoorCommandTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetLiftCarDoorCommandTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetLiftCarDoorCommandTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetLiftCarDoorCommandTagged) IsBACnetLiftCarDoorCommandTagged() {}

func (m *_BACnetLiftCarDoorCommandTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetLiftCarDoorCommandTagged) deepCopy() *_BACnetLiftCarDoorCommandTagged {
	if m == nil {
		return nil
	}
	_BACnetLiftCarDoorCommandTaggedCopy := &_BACnetLiftCarDoorCommandTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetLiftCarDoorCommandTaggedCopy
}

func (m *_BACnetLiftCarDoorCommandTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
