/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SALDataVentilation is the corresponding interface of SALDataVentilation
type SALDataVentilation interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SALData
	// GetVentilationData returns VentilationData (property field)
	GetVentilationData() LightingData
	// IsSALDataVentilation is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSALDataVentilation()
	// CreateBuilder creates a SALDataVentilationBuilder
	CreateSALDataVentilationBuilder() SALDataVentilationBuilder
}

// _SALDataVentilation is the data-structure of this message
type _SALDataVentilation struct {
	SALDataContract
	VentilationData LightingData
}

var _ SALDataVentilation = (*_SALDataVentilation)(nil)
var _ SALDataRequirements = (*_SALDataVentilation)(nil)

// NewSALDataVentilation factory function for _SALDataVentilation
func NewSALDataVentilation(salData SALData, ventilationData LightingData) *_SALDataVentilation {
	if ventilationData == nil {
		panic("ventilationData of type LightingData for SALDataVentilation must not be nil")
	}
	_result := &_SALDataVentilation{
		SALDataContract: NewSALData(salData),
		VentilationData: ventilationData,
	}
	_result.SALDataContract.(*_SALData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SALDataVentilationBuilder is a builder for SALDataVentilation
type SALDataVentilationBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(ventilationData LightingData) SALDataVentilationBuilder
	// WithVentilationData adds VentilationData (property field)
	WithVentilationData(LightingData) SALDataVentilationBuilder
	// WithVentilationDataBuilder adds VentilationData (property field) which is build by the builder
	WithVentilationDataBuilder(func(LightingDataBuilder) LightingDataBuilder) SALDataVentilationBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SALDataBuilder
	// Build builds the SALDataVentilation or returns an error if something is wrong
	Build() (SALDataVentilation, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SALDataVentilation
}

// NewSALDataVentilationBuilder() creates a SALDataVentilationBuilder
func NewSALDataVentilationBuilder() SALDataVentilationBuilder {
	return &_SALDataVentilationBuilder{_SALDataVentilation: new(_SALDataVentilation)}
}

type _SALDataVentilationBuilder struct {
	*_SALDataVentilation

	parentBuilder *_SALDataBuilder

	collectedErr []error
}

var _ (SALDataVentilationBuilder) = (*_SALDataVentilationBuilder)(nil)

func (b *_SALDataVentilationBuilder) setParent(contract SALDataContract) {
	b.SALDataContract = contract
	contract.(*_SALData)._SubType = b._SALDataVentilation
}

func (b *_SALDataVentilationBuilder) WithMandatoryFields(ventilationData LightingData) SALDataVentilationBuilder {
	return b.WithVentilationData(ventilationData)
}

func (b *_SALDataVentilationBuilder) WithVentilationData(ventilationData LightingData) SALDataVentilationBuilder {
	b.VentilationData = ventilationData
	return b
}

func (b *_SALDataVentilationBuilder) WithVentilationDataBuilder(builderSupplier func(LightingDataBuilder) LightingDataBuilder) SALDataVentilationBuilder {
	builder := builderSupplier(b.VentilationData.CreateLightingDataBuilder())
	var err error
	b.VentilationData, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "LightingDataBuilder failed"))
	}
	return b
}

func (b *_SALDataVentilationBuilder) Build() (SALDataVentilation, error) {
	if b.VentilationData == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'ventilationData' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._SALDataVentilation.deepCopy(), nil
}

func (b *_SALDataVentilationBuilder) MustBuild() SALDataVentilation {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SALDataVentilationBuilder) Done() SALDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSALDataBuilder().(*_SALDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SALDataVentilationBuilder) buildForSALData() (SALData, error) {
	return b.Build()
}

func (b *_SALDataVentilationBuilder) DeepCopy() any {
	_copy := b.CreateSALDataVentilationBuilder().(*_SALDataVentilationBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateSALDataVentilationBuilder creates a SALDataVentilationBuilder
func (b *_SALDataVentilation) CreateSALDataVentilationBuilder() SALDataVentilationBuilder {
	if b == nil {
		return NewSALDataVentilationBuilder()
	}
	return &_SALDataVentilationBuilder{_SALDataVentilation: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SALDataVentilation) GetApplicationId() ApplicationId {
	return ApplicationId_VENTILATION
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SALDataVentilation) GetParent() SALDataContract {
	return m.SALDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SALDataVentilation) GetVentilationData() LightingData {
	return m.VentilationData
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastSALDataVentilation(structType any) SALDataVentilation {
	if casted, ok := structType.(SALDataVentilation); ok {
		return casted
	}
	if casted, ok := structType.(*SALDataVentilation); ok {
		return *casted
	}
	return nil
}

func (m *_SALDataVentilation) GetTypeName() string {
	return "SALDataVentilation"
}

func (m *_SALDataVentilation) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SALDataContract.(*_SALData).getLengthInBits(ctx))

	// Simple field (ventilationData)
	lengthInBits += m.VentilationData.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_SALDataVentilation) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SALDataVentilation) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SALData, applicationId ApplicationId) (__sALDataVentilation SALDataVentilation, err error) {
	m.SALDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SALDataVentilation"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SALDataVentilation")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	ventilationData, err := ReadSimpleField[LightingData](ctx, "ventilationData", ReadComplex[LightingData](LightingDataParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'ventilationData' field"))
	}
	m.VentilationData = ventilationData

	if closeErr := readBuffer.CloseContext("SALDataVentilation"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SALDataVentilation")
	}

	return m, nil
}

func (m *_SALDataVentilation) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SALDataVentilation) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SALDataVentilation"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SALDataVentilation")
		}

		if err := WriteSimpleField[LightingData](ctx, "ventilationData", m.GetVentilationData(), WriteComplex[LightingData](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'ventilationData' field")
		}

		if popErr := writeBuffer.PopContext("SALDataVentilation"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SALDataVentilation")
		}
		return nil
	}
	return m.SALDataContract.(*_SALData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SALDataVentilation) IsSALDataVentilation() {}

func (m *_SALDataVentilation) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SALDataVentilation) deepCopy() *_SALDataVentilation {
	if m == nil {
		return nil
	}
	_SALDataVentilationCopy := &_SALDataVentilation{
		m.SALDataContract.(*_SALData).deepCopy(),
		utils.DeepCopy[LightingData](m.VentilationData),
	}
	_SALDataVentilationCopy.SALDataContract.(*_SALData)._SubType = m
	return _SALDataVentilationCopy
}

func (m *_SALDataVentilation) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
