/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum BACnetObjectTypesSupported {
  ANALOG_INPUT((short) 0),
  ANALOG_OUTPUT((short) 1),
  ANALOG_VALUE((short) 2),
  BINARY_INPUT((short) 3),
  BINARY_OUTPUT((short) 4),
  BINARY_VALUE((short) 5),
  CALENDAR((short) 6),
  COMMAND((short) 7),
  DEVICE((short) 8),
  EVENT_ENROLLMENT((short) 9),
  FILE((short) 10),
  GROUP((short) 11),
  LOOP((short) 12),
  MULTI_STATE_INPUT((short) 13),
  MULTI_STATE_OUTPUT((short) 14),
  NOTIFICATION_CLASS((short) 15),
  PROGRAM((short) 16),
  SCHEDULE((short) 17),
  AVERAGING((short) 18),
  MULTI_STATE_VALUE((short) 19),
  TREND_LOG((short) 20),
  LIFE_SAFETY_POINT((short) 21),
  LIFE_SAFETY_ZONE((short) 22),
  ACCUMULATOR((short) 23),
  PULSE_CONVERTER((short) 24),
  EVENT_LOG((short) 25),
  GLOBAL_GROUP((short) 26),
  TREND_LOG_MULTIPLE((short) 27),
  LOAD_CONTROL((short) 28),
  STRUCTURED_VIEW((short) 29),
  ACCESS_DOOR((short) 30),
  TIMER((short) 31),
  ACCESS_CREDENTIAL((short) 32),
  ACCESS_POINT((short) 33),
  ACCESS_RIGHTS((short) 34),
  ACCESS_USER((short) 35),
  ACCESS_ZONE((short) 36),
  CREDENTIAL_DATA_INPUT((short) 37),
  NETWORK_SECURITY((short) 38),
  BITSTRING_VALUE((short) 39),
  CHARACTERSTRING_VALUE((short) 40),
  DATEPATTERN_VALUE((short) 41),
  DATE_VALUE((short) 42),
  DATETIMEPATTERN_VALUE((short) 43),
  DATETIME_VALUE((short) 44),
  INTEGER_VALUE((short) 45),
  LARGE_ANALOG_VALUE((short) 46),
  OCTETSTRING_VALUE((short) 47),
  POSITIVE_INTEGER_VALUE((short) 48),
  TIMEPATTERN_VALUE((short) 49),
  TIME_VALUE((short) 50),
  NOTIFICATION_FORWARDER((short) 51),
  ALERT_ENROLLMENT((short) 52),
  CHANNEL((short) 53),
  LIGHTING_OUTPUT((short) 54),
  BINARY_LIGHTING_OUTPUT((short) 55),
  NETWORK_PORT((short) 56),
  ELEVATOR_GROUP((short) 57),
  ESCALATOR((short) 58),
  LIFT((short) 59);
  private static final Map<Short, BACnetObjectTypesSupported> map;

  static {
    map = new HashMap<>();
    for (BACnetObjectTypesSupported value : BACnetObjectTypesSupported.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;

  BACnetObjectTypesSupported(short value) {
    this.value = value;
  }

  public short getValue() {
    return value;
  }

  public static BACnetObjectTypesSupported enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
